<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultMultiLoanValue pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultMultiLoanValue extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfArrayOfString
     */
    public $data;
    /**
     * Constructor method for ResultMultiLoanValue
     * @uses PathResultMultiLoanValue::setStatus()
     * @uses PathResultMultiLoanValue::setMessage()
     * @uses PathResultMultiLoanValue::setData()
     * @param int $status
     * @param string $message
     * @param \Path\pathArrayType\PathArrayOfArrayOfString $data
     */
    public function __construct($status = null, $message = null, \Path\pathArrayType\PathArrayOfArrayOfString $data = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setData($data);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultMultiLoanValue
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Path\pathStructType\PathResultMultiLoanValue
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get data value
     * @return \Path\pathArrayType\PathArrayOfArrayOfString|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param \Path\pathArrayType\PathArrayOfArrayOfString $data
     * @return \Path\pathStructType\PathResultMultiLoanValue
     */
    public function setData(\Path\pathArrayType\PathArrayOfArrayOfString $data = null)
    {
        $this->data = $data;
        return $this;
    }
}
