<?php

namespace Path\pathServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add pathServiceType
 * @package Path
 * @subpackage Services
 */
class PathAdd extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddNewLoanFeeData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathAddNewLoanFeeData $parameters
     * @return \Path\pathStructType\PathAddNewLoanFeeDataResponse|bool
     */
    public function AddNewLoanFeeData(\Path\pathStructType\PathAddNewLoanFeeData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddNewLoanFeeData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathAddDocument $parameters
     * @return \Path\pathStructType\PathAddDocumentResponse|bool
     */
    public function AddDocument(\Path\pathStructType\PathAddDocument $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Path\pathStructType\PathAddDocumentResponse|\Path\pathStructType\PathAddNewLoanFeeDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
