<?php

namespace Path\pathArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocumentInfo pathArrayType
 * @package Path
 * @subpackage Arrays
 */
class PathArrayOfDocumentInfo extends AbstractStructArrayBase
{
    /**
     * The DocumentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Path\pathStructType\PathDocumentInfo[]
     */
    public $DocumentInfo;
    /**
     * Constructor method for ArrayOfDocumentInfo
     * @uses PathArrayOfDocumentInfo::setDocumentInfo()
     * @param \Path\pathStructType\PathDocumentInfo[] $documentInfo
     */
    public function __construct(array $documentInfo = array())
    {
        $this
            ->setDocumentInfo($documentInfo);
    }
    /**
     * Get DocumentInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Path\pathStructType\PathDocumentInfo[]|null
     */
    public function getDocumentInfo()
    {
        return isset($this->DocumentInfo) ? $this->DocumentInfo : null;
    }
    /**
     * Set DocumentInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathDocumentInfo[] $documentInfo
     * @return \Path\pathArrayType\PathArrayOfDocumentInfo
     */
    public function setDocumentInfo(array $documentInfo = array())
    {
        foreach ($documentInfo as $arrayOfDocumentInfoDocumentInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfDocumentInfoDocumentInfoItem instanceof \Path\pathStructType\PathDocumentInfo) {
                throw new \InvalidArgumentException(sprintf('The DocumentInfo property can only contain items of \Path\pathStructType\PathDocumentInfo, "%s" given', is_object($arrayOfDocumentInfoDocumentInfoItem) ? get_class($arrayOfDocumentInfoDocumentInfoItem) : gettype($arrayOfDocumentInfoDocumentInfoItem)), __LINE__);
            }
        }
        if (is_null($documentInfo) || (is_array($documentInfo) && empty($documentInfo))) {
            unset($this->DocumentInfo);
        } else {
            $this->DocumentInfo = $documentInfo;
        }
        return $this;
    }
    /**
     * Add item to DocumentInfo value
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathDocumentInfo $item
     * @return \Path\pathArrayType\PathArrayOfDocumentInfo
     */
    public function addToDocumentInfo(\Path\pathStructType\PathDocumentInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Path\pathStructType\PathDocumentInfo) {
            throw new \InvalidArgumentException(sprintf('The DocumentInfo property can only contain items of \Path\pathStructType\PathDocumentInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DocumentInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Path\pathStructType\PathDocumentInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Path\pathStructType\PathDocumentInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Path\pathStructType\PathDocumentInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Path\pathStructType\PathDocumentInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Path\pathStructType\PathDocumentInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DocumentInfo
     */
    public function getAttributeName()
    {
        return 'DocumentInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Path\pathArrayType\PathArrayOfDocumentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
