<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetLoanDataByToken pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathSetLoanDataByToken extends AbstractStructBase
{
    /**
     * The vendorid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorid;
    /**
     * The apitoken
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $apitoken;
    /**
     * The vendorpw
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorpw;
    /**
     * The loandata
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfLoanKeyValuePair1
     */
    public $loandata;
    /**
     * Constructor method for SetLoanDataByToken
     * @uses PathSetLoanDataByToken::setVendorid()
     * @uses PathSetLoanDataByToken::setApitoken()
     * @uses PathSetLoanDataByToken::setVendorpw()
     * @uses PathSetLoanDataByToken::setLoandata()
     * @param string $vendorid
     * @param string $apitoken
     * @param string $vendorpw
     * @param \Path\pathArrayType\PathArrayOfLoanKeyValuePair1 $loandata
     */
    public function __construct($vendorid = null, $apitoken = null, $vendorpw = null, \Path\pathArrayType\PathArrayOfLoanKeyValuePair1 $loandata = null)
    {
        $this
            ->setVendorid($vendorid)
            ->setApitoken($apitoken)
            ->setVendorpw($vendorpw)
            ->setLoandata($loandata);
    }
    /**
     * Get vendorid value
     * @return string|null
     */
    public function getVendorid()
    {
        return $this->vendorid;
    }
    /**
     * Set vendorid value
     * @param string $vendorid
     * @return \Path\pathStructType\PathSetLoanDataByToken
     */
    public function setVendorid($vendorid = null)
    {
        // validation for constraint: string
        if (!is_null($vendorid) && !is_string($vendorid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorid)), __LINE__);
        }
        $this->vendorid = $vendorid;
        return $this;
    }
    /**
     * Get apitoken value
     * @return string|null
     */
    public function getApitoken()
    {
        return $this->apitoken;
    }
    /**
     * Set apitoken value
     * @param string $apitoken
     * @return \Path\pathStructType\PathSetLoanDataByToken
     */
    public function setApitoken($apitoken = null)
    {
        // validation for constraint: string
        if (!is_null($apitoken) && !is_string($apitoken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apitoken)), __LINE__);
        }
        $this->apitoken = $apitoken;
        return $this;
    }
    /**
     * Get vendorpw value
     * @return string|null
     */
    public function getVendorpw()
    {
        return $this->vendorpw;
    }
    /**
     * Set vendorpw value
     * @param string $vendorpw
     * @return \Path\pathStructType\PathSetLoanDataByToken
     */
    public function setVendorpw($vendorpw = null)
    {
        // validation for constraint: string
        if (!is_null($vendorpw) && !is_string($vendorpw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorpw)), __LINE__);
        }
        $this->vendorpw = $vendorpw;
        return $this;
    }
    /**
     * Get loandata value
     * @return \Path\pathArrayType\PathArrayOfLoanKeyValuePair1|null
     */
    public function getLoandata()
    {
        return $this->loandata;
    }
    /**
     * Set loandata value
     * @param \Path\pathArrayType\PathArrayOfLoanKeyValuePair1 $loandata
     * @return \Path\pathStructType\PathSetLoanDataByToken
     */
    public function setLoandata(\Path\pathArrayType\PathArrayOfLoanKeyValuePair1 $loandata = null)
    {
        $this->loandata = $loandata;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Path\pathStructType\PathSetLoanDataByToken
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
