<?php

namespace Path\pathArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFeeData pathArrayType
 * @package Path
 * @subpackage Arrays
 */
class PathArrayOfFeeData extends AbstractStructArrayBase
{
    /**
     * The FeeData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Path\pathStructType\PathFeeData[]
     */
    public $FeeData;
    /**
     * Constructor method for ArrayOfFeeData
     * @uses PathArrayOfFeeData::setFeeData()
     * @param \Path\pathStructType\PathFeeData[] $feeData
     */
    public function __construct(array $feeData = array())
    {
        $this
            ->setFeeData($feeData);
    }
    /**
     * Get FeeData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Path\pathStructType\PathFeeData[]|null
     */
    public function getFeeData()
    {
        return isset($this->FeeData) ? $this->FeeData : null;
    }
    /**
     * Set FeeData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathFeeData[] $feeData
     * @return \Path\pathArrayType\PathArrayOfFeeData
     */
    public function setFeeData(array $feeData = array())
    {
        foreach ($feeData as $arrayOfFeeDataFeeDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfFeeDataFeeDataItem instanceof \Path\pathStructType\PathFeeData) {
                throw new \InvalidArgumentException(sprintf('The FeeData property can only contain items of \Path\pathStructType\PathFeeData, "%s" given', is_object($arrayOfFeeDataFeeDataItem) ? get_class($arrayOfFeeDataFeeDataItem) : gettype($arrayOfFeeDataFeeDataItem)), __LINE__);
            }
        }
        if (is_null($feeData) || (is_array($feeData) && empty($feeData))) {
            unset($this->FeeData);
        } else {
            $this->FeeData = $feeData;
        }
        return $this;
    }
    /**
     * Add item to FeeData value
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathFeeData $item
     * @return \Path\pathArrayType\PathArrayOfFeeData
     */
    public function addToFeeData(\Path\pathStructType\PathFeeData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Path\pathStructType\PathFeeData) {
            throw new \InvalidArgumentException(sprintf('The FeeData property can only contain items of \Path\pathStructType\PathFeeData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FeeData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Path\pathStructType\PathFeeData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Path\pathStructType\PathFeeData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Path\pathStructType\PathFeeData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Path\pathStructType\PathFeeData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Path\pathStructType\PathFeeData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FeeData
     */
    public function getAttributeName()
    {
        return 'FeeData';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Path\pathArrayType\PathArrayOfFeeData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
