<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeeData pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathFeeData extends AbstractStructBase
{
    /**
     * The feeid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $feeid;
    /**
     * The AdditionalAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AdditionalAmount;
    /**
     * The AnnualAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AnnualAmount;
    /**
     * The APRIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $APRIndicator;
    /**
     * The BorrowerAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BorrowerAmt;
    /**
     * The BorrowerPct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BorrowerPct;
    /**
     * The BorrowerPOCIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $BorrowerPOCIndicator;
    /**
     * The BorrowerSelectedIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $BorrowerSelectedIndicator;
    /**
     * The BrokerAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BrokerAmt;
    /**
     * The BrokerPct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BrokerPct;
    /**
     * The BrokerPOCIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $BrokerPOCIndicator;
    /**
     * The CalculateNumberDaysIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CalculateNumberDaysIndicator;
    /**
     * The CorrespondentAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CorrespondentAmt;
    /**
     * The CorrespondentPct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CorrespondentPct;
    /**
     * The CorrespondentPOCIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CorrespondentPOCIndicator;
    /**
     * The CustomFeeIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CustomFeeIndicator;
    /**
     * The ExcludableIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ExcludableIndicator;
    /**
     * The ExcludeFromMortgageDeedIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ExcludeFromMortgageDeedIndicator;
    /**
     * The FederalBonaFideIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $FederalBonaFideIndicator;
    /**
     * The FHAAllowableIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $FHAAllowableIndicator;
    /**
     * The FinancedIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $FinancedIndicator;
    /**
     * The GSEBonaFideIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $GSEBonaFideIndicator;
    /**
     * The LenderAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $LenderAmt;
    /**
     * The LenderPct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $LenderPct;
    /**
     * The LenderPOCIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $LenderPOCIndicator;
    /**
     * The Percent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Percent;
    /**
     * The POCIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $POCIndicator;
    /**
     * The QMIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $QMIndicator;
    /**
     * The SellerAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SellerAmt;
    /**
     * The SellerPct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SellerPct;
    /**
     * The SellerPOCIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SellerPOCIndicator;
    /**
     * The ShoppableIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ShoppableIndicator;
    /**
     * The SplitByAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SplitByAmt;
    /**
     * The SplitByPct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SplitByPct;
    /**
     * The StateBonaFideIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $StateBonaFideIndicator;
    /**
     * The ThirdPartyAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ThirdPartyAmt;
    /**
     * The ThirdPartyPct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ThirdPartyPct;
    /**
     * The ThirdPartyPOCIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ThirdPartyPOCIndicator;
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The BasedOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BasedOn;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The COCDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $COCDate;
    /**
     * The COCReason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $COCReason;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comments;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contact;
    /**
     * The DailyInterestFromDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DailyInterestFromDate;
    /**
     * The DailyInterestToDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DailyInterestToDate;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The FeeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeName;
    /**
     * The FeeSection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeSection;
    /**
     * The FeeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeType;
    /**
     * The Frequency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Frequency;
    /**
     * The MonthsCushion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MonthsCushion;
    /**
     * The NumberDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumberDays;
    /**
     * The NumberMonths
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumberMonths;
    /**
     * The PaidBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaidBy;
    /**
     * The PaidTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaidTo;
    /**
     * The PaidToCompany
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaidToCompany;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The PrepaidType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrepaidType;
    /**
     * The ServiceProviderSourceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderSourceType;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The WithholdFromWire
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WithholdFromWire;
    /**
     * The Zip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * Constructor method for FeeData
     * @uses PathFeeData::setFeeid()
     * @uses PathFeeData::setAdditionalAmount()
     * @uses PathFeeData::setAnnualAmount()
     * @uses PathFeeData::setAPRIndicator()
     * @uses PathFeeData::setBorrowerAmt()
     * @uses PathFeeData::setBorrowerPct()
     * @uses PathFeeData::setBorrowerPOCIndicator()
     * @uses PathFeeData::setBorrowerSelectedIndicator()
     * @uses PathFeeData::setBrokerAmt()
     * @uses PathFeeData::setBrokerPct()
     * @uses PathFeeData::setBrokerPOCIndicator()
     * @uses PathFeeData::setCalculateNumberDaysIndicator()
     * @uses PathFeeData::setCorrespondentAmt()
     * @uses PathFeeData::setCorrespondentPct()
     * @uses PathFeeData::setCorrespondentPOCIndicator()
     * @uses PathFeeData::setCustomFeeIndicator()
     * @uses PathFeeData::setExcludableIndicator()
     * @uses PathFeeData::setExcludeFromMortgageDeedIndicator()
     * @uses PathFeeData::setFederalBonaFideIndicator()
     * @uses PathFeeData::setFHAAllowableIndicator()
     * @uses PathFeeData::setFinancedIndicator()
     * @uses PathFeeData::setGSEBonaFideIndicator()
     * @uses PathFeeData::setLenderAmt()
     * @uses PathFeeData::setLenderPct()
     * @uses PathFeeData::setLenderPOCIndicator()
     * @uses PathFeeData::setPercent()
     * @uses PathFeeData::setPOCIndicator()
     * @uses PathFeeData::setQMIndicator()
     * @uses PathFeeData::setSellerAmt()
     * @uses PathFeeData::setSellerPct()
     * @uses PathFeeData::setSellerPOCIndicator()
     * @uses PathFeeData::setShoppableIndicator()
     * @uses PathFeeData::setSplitByAmt()
     * @uses PathFeeData::setSplitByPct()
     * @uses PathFeeData::setStateBonaFideIndicator()
     * @uses PathFeeData::setThirdPartyAmt()
     * @uses PathFeeData::setThirdPartyPct()
     * @uses PathFeeData::setThirdPartyPOCIndicator()
     * @uses PathFeeData::setAddress1()
     * @uses PathFeeData::setAddress2()
     * @uses PathFeeData::setBasedOn()
     * @uses PathFeeData::setCity()
     * @uses PathFeeData::setCOCDate()
     * @uses PathFeeData::setCOCReason()
     * @uses PathFeeData::setComments()
     * @uses PathFeeData::setContact()
     * @uses PathFeeData::setDailyInterestFromDate()
     * @uses PathFeeData::setDailyInterestToDate()
     * @uses PathFeeData::setEmail()
     * @uses PathFeeData::setFeeName()
     * @uses PathFeeData::setFeeSection()
     * @uses PathFeeData::setFeeType()
     * @uses PathFeeData::setFrequency()
     * @uses PathFeeData::setMonthsCushion()
     * @uses PathFeeData::setNumberDays()
     * @uses PathFeeData::setNumberMonths()
     * @uses PathFeeData::setPaidBy()
     * @uses PathFeeData::setPaidTo()
     * @uses PathFeeData::setPaidToCompany()
     * @uses PathFeeData::setPhone()
     * @uses PathFeeData::setPrepaidType()
     * @uses PathFeeData::setServiceProviderSourceType()
     * @uses PathFeeData::setState()
     * @uses PathFeeData::setWithholdFromWire()
     * @uses PathFeeData::setZip()
     * @param int $feeid
     * @param float $additionalAmount
     * @param float $annualAmount
     * @param bool $aPRIndicator
     * @param float $borrowerAmt
     * @param float $borrowerPct
     * @param bool $borrowerPOCIndicator
     * @param bool $borrowerSelectedIndicator
     * @param float $brokerAmt
     * @param float $brokerPct
     * @param bool $brokerPOCIndicator
     * @param bool $calculateNumberDaysIndicator
     * @param float $correspondentAmt
     * @param float $correspondentPct
     * @param bool $correspondentPOCIndicator
     * @param bool $customFeeIndicator
     * @param bool $excludableIndicator
     * @param bool $excludeFromMortgageDeedIndicator
     * @param bool $federalBonaFideIndicator
     * @param bool $fHAAllowableIndicator
     * @param bool $financedIndicator
     * @param bool $gSEBonaFideIndicator
     * @param float $lenderAmt
     * @param float $lenderPct
     * @param bool $lenderPOCIndicator
     * @param float $percent
     * @param bool $pOCIndicator
     * @param bool $qMIndicator
     * @param float $sellerAmt
     * @param float $sellerPct
     * @param bool $sellerPOCIndicator
     * @param bool $shoppableIndicator
     * @param bool $splitByAmt
     * @param bool $splitByPct
     * @param bool $stateBonaFideIndicator
     * @param float $thirdPartyAmt
     * @param float $thirdPartyPct
     * @param bool $thirdPartyPOCIndicator
     * @param string $address1
     * @param string $address2
     * @param string $basedOn
     * @param string $city
     * @param string $cOCDate
     * @param string $cOCReason
     * @param string $comments
     * @param string $contact
     * @param string $dailyInterestFromDate
     * @param string $dailyInterestToDate
     * @param string $email
     * @param string $feeName
     * @param string $feeSection
     * @param string $feeType
     * @param string $frequency
     * @param string $monthsCushion
     * @param string $numberDays
     * @param string $numberMonths
     * @param string $paidBy
     * @param string $paidTo
     * @param string $paidToCompany
     * @param string $phone
     * @param string $prepaidType
     * @param string $serviceProviderSourceType
     * @param string $state
     * @param string $withholdFromWire
     * @param string $zip
     */
    public function __construct($feeid = null, $additionalAmount = null, $annualAmount = null, $aPRIndicator = null, $borrowerAmt = null, $borrowerPct = null, $borrowerPOCIndicator = null, $borrowerSelectedIndicator = null, $brokerAmt = null, $brokerPct = null, $brokerPOCIndicator = null, $calculateNumberDaysIndicator = null, $correspondentAmt = null, $correspondentPct = null, $correspondentPOCIndicator = null, $customFeeIndicator = null, $excludableIndicator = null, $excludeFromMortgageDeedIndicator = null, $federalBonaFideIndicator = null, $fHAAllowableIndicator = null, $financedIndicator = null, $gSEBonaFideIndicator = null, $lenderAmt = null, $lenderPct = null, $lenderPOCIndicator = null, $percent = null, $pOCIndicator = null, $qMIndicator = null, $sellerAmt = null, $sellerPct = null, $sellerPOCIndicator = null, $shoppableIndicator = null, $splitByAmt = null, $splitByPct = null, $stateBonaFideIndicator = null, $thirdPartyAmt = null, $thirdPartyPct = null, $thirdPartyPOCIndicator = null, $address1 = null, $address2 = null, $basedOn = null, $city = null, $cOCDate = null, $cOCReason = null, $comments = null, $contact = null, $dailyInterestFromDate = null, $dailyInterestToDate = null, $email = null, $feeName = null, $feeSection = null, $feeType = null, $frequency = null, $monthsCushion = null, $numberDays = null, $numberMonths = null, $paidBy = null, $paidTo = null, $paidToCompany = null, $phone = null, $prepaidType = null, $serviceProviderSourceType = null, $state = null, $withholdFromWire = null, $zip = null)
    {
        $this
            ->setFeeid($feeid)
            ->setAdditionalAmount($additionalAmount)
            ->setAnnualAmount($annualAmount)
            ->setAPRIndicator($aPRIndicator)
            ->setBorrowerAmt($borrowerAmt)
            ->setBorrowerPct($borrowerPct)
            ->setBorrowerPOCIndicator($borrowerPOCIndicator)
            ->setBorrowerSelectedIndicator($borrowerSelectedIndicator)
            ->setBrokerAmt($brokerAmt)
            ->setBrokerPct($brokerPct)
            ->setBrokerPOCIndicator($brokerPOCIndicator)
            ->setCalculateNumberDaysIndicator($calculateNumberDaysIndicator)
            ->setCorrespondentAmt($correspondentAmt)
            ->setCorrespondentPct($correspondentPct)
            ->setCorrespondentPOCIndicator($correspondentPOCIndicator)
            ->setCustomFeeIndicator($customFeeIndicator)
            ->setExcludableIndicator($excludableIndicator)
            ->setExcludeFromMortgageDeedIndicator($excludeFromMortgageDeedIndicator)
            ->setFederalBonaFideIndicator($federalBonaFideIndicator)
            ->setFHAAllowableIndicator($fHAAllowableIndicator)
            ->setFinancedIndicator($financedIndicator)
            ->setGSEBonaFideIndicator($gSEBonaFideIndicator)
            ->setLenderAmt($lenderAmt)
            ->setLenderPct($lenderPct)
            ->setLenderPOCIndicator($lenderPOCIndicator)
            ->setPercent($percent)
            ->setPOCIndicator($pOCIndicator)
            ->setQMIndicator($qMIndicator)
            ->setSellerAmt($sellerAmt)
            ->setSellerPct($sellerPct)
            ->setSellerPOCIndicator($sellerPOCIndicator)
            ->setShoppableIndicator($shoppableIndicator)
            ->setSplitByAmt($splitByAmt)
            ->setSplitByPct($splitByPct)
            ->setStateBonaFideIndicator($stateBonaFideIndicator)
            ->setThirdPartyAmt($thirdPartyAmt)
            ->setThirdPartyPct($thirdPartyPct)
            ->setThirdPartyPOCIndicator($thirdPartyPOCIndicator)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setBasedOn($basedOn)
            ->setCity($city)
            ->setCOCDate($cOCDate)
            ->setCOCReason($cOCReason)
            ->setComments($comments)
            ->setContact($contact)
            ->setDailyInterestFromDate($dailyInterestFromDate)
            ->setDailyInterestToDate($dailyInterestToDate)
            ->setEmail($email)
            ->setFeeName($feeName)
            ->setFeeSection($feeSection)
            ->setFeeType($feeType)
            ->setFrequency($frequency)
            ->setMonthsCushion($monthsCushion)
            ->setNumberDays($numberDays)
            ->setNumberMonths($numberMonths)
            ->setPaidBy($paidBy)
            ->setPaidTo($paidTo)
            ->setPaidToCompany($paidToCompany)
            ->setPhone($phone)
            ->setPrepaidType($prepaidType)
            ->setServiceProviderSourceType($serviceProviderSourceType)
            ->setState($state)
            ->setWithholdFromWire($withholdFromWire)
            ->setZip($zip);
    }
    /**
     * Get feeid value
     * @return int
     */
    public function getFeeid()
    {
        return $this->feeid;
    }
    /**
     * Set feeid value
     * @param int $feeid
     * @return \Path\pathStructType\PathFeeData
     */
    public function setFeeid($feeid = null)
    {
        // validation for constraint: int
        if (!is_null($feeid) && !is_numeric($feeid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($feeid)), __LINE__);
        }
        $this->feeid = $feeid;
        return $this;
    }
    /**
     * Get AdditionalAmount value
     * @return float
     */
    public function getAdditionalAmount()
    {
        return $this->AdditionalAmount;
    }
    /**
     * Set AdditionalAmount value
     * @param float $additionalAmount
     * @return \Path\pathStructType\PathFeeData
     */
    public function setAdditionalAmount($additionalAmount = null)
    {
        $this->AdditionalAmount = $additionalAmount;
        return $this;
    }
    /**
     * Get AnnualAmount value
     * @return float
     */
    public function getAnnualAmount()
    {
        return $this->AnnualAmount;
    }
    /**
     * Set AnnualAmount value
     * @param float $annualAmount
     * @return \Path\pathStructType\PathFeeData
     */
    public function setAnnualAmount($annualAmount = null)
    {
        $this->AnnualAmount = $annualAmount;
        return $this;
    }
    /**
     * Get APRIndicator value
     * @return bool
     */
    public function getAPRIndicator()
    {
        return $this->APRIndicator;
    }
    /**
     * Set APRIndicator value
     * @param bool $aPRIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setAPRIndicator($aPRIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($aPRIndicator) && !is_bool($aPRIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aPRIndicator)), __LINE__);
        }
        $this->APRIndicator = $aPRIndicator;
        return $this;
    }
    /**
     * Get BorrowerAmt value
     * @return float
     */
    public function getBorrowerAmt()
    {
        return $this->BorrowerAmt;
    }
    /**
     * Set BorrowerAmt value
     * @param float $borrowerAmt
     * @return \Path\pathStructType\PathFeeData
     */
    public function setBorrowerAmt($borrowerAmt = null)
    {
        $this->BorrowerAmt = $borrowerAmt;
        return $this;
    }
    /**
     * Get BorrowerPct value
     * @return float
     */
    public function getBorrowerPct()
    {
        return $this->BorrowerPct;
    }
    /**
     * Set BorrowerPct value
     * @param float $borrowerPct
     * @return \Path\pathStructType\PathFeeData
     */
    public function setBorrowerPct($borrowerPct = null)
    {
        $this->BorrowerPct = $borrowerPct;
        return $this;
    }
    /**
     * Get BorrowerPOCIndicator value
     * @return bool
     */
    public function getBorrowerPOCIndicator()
    {
        return $this->BorrowerPOCIndicator;
    }
    /**
     * Set BorrowerPOCIndicator value
     * @param bool $borrowerPOCIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setBorrowerPOCIndicator($borrowerPOCIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($borrowerPOCIndicator) && !is_bool($borrowerPOCIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($borrowerPOCIndicator)), __LINE__);
        }
        $this->BorrowerPOCIndicator = $borrowerPOCIndicator;
        return $this;
    }
    /**
     * Get BorrowerSelectedIndicator value
     * @return bool
     */
    public function getBorrowerSelectedIndicator()
    {
        return $this->BorrowerSelectedIndicator;
    }
    /**
     * Set BorrowerSelectedIndicator value
     * @param bool $borrowerSelectedIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setBorrowerSelectedIndicator($borrowerSelectedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($borrowerSelectedIndicator) && !is_bool($borrowerSelectedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($borrowerSelectedIndicator)), __LINE__);
        }
        $this->BorrowerSelectedIndicator = $borrowerSelectedIndicator;
        return $this;
    }
    /**
     * Get BrokerAmt value
     * @return float
     */
    public function getBrokerAmt()
    {
        return $this->BrokerAmt;
    }
    /**
     * Set BrokerAmt value
     * @param float $brokerAmt
     * @return \Path\pathStructType\PathFeeData
     */
    public function setBrokerAmt($brokerAmt = null)
    {
        $this->BrokerAmt = $brokerAmt;
        return $this;
    }
    /**
     * Get BrokerPct value
     * @return float
     */
    public function getBrokerPct()
    {
        return $this->BrokerPct;
    }
    /**
     * Set BrokerPct value
     * @param float $brokerPct
     * @return \Path\pathStructType\PathFeeData
     */
    public function setBrokerPct($brokerPct = null)
    {
        $this->BrokerPct = $brokerPct;
        return $this;
    }
    /**
     * Get BrokerPOCIndicator value
     * @return bool
     */
    public function getBrokerPOCIndicator()
    {
        return $this->BrokerPOCIndicator;
    }
    /**
     * Set BrokerPOCIndicator value
     * @param bool $brokerPOCIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setBrokerPOCIndicator($brokerPOCIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($brokerPOCIndicator) && !is_bool($brokerPOCIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($brokerPOCIndicator)), __LINE__);
        }
        $this->BrokerPOCIndicator = $brokerPOCIndicator;
        return $this;
    }
    /**
     * Get CalculateNumberDaysIndicator value
     * @return bool
     */
    public function getCalculateNumberDaysIndicator()
    {
        return $this->CalculateNumberDaysIndicator;
    }
    /**
     * Set CalculateNumberDaysIndicator value
     * @param bool $calculateNumberDaysIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setCalculateNumberDaysIndicator($calculateNumberDaysIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculateNumberDaysIndicator) && !is_bool($calculateNumberDaysIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($calculateNumberDaysIndicator)), __LINE__);
        }
        $this->CalculateNumberDaysIndicator = $calculateNumberDaysIndicator;
        return $this;
    }
    /**
     * Get CorrespondentAmt value
     * @return float
     */
    public function getCorrespondentAmt()
    {
        return $this->CorrespondentAmt;
    }
    /**
     * Set CorrespondentAmt value
     * @param float $correspondentAmt
     * @return \Path\pathStructType\PathFeeData
     */
    public function setCorrespondentAmt($correspondentAmt = null)
    {
        $this->CorrespondentAmt = $correspondentAmt;
        return $this;
    }
    /**
     * Get CorrespondentPct value
     * @return float
     */
    public function getCorrespondentPct()
    {
        return $this->CorrespondentPct;
    }
    /**
     * Set CorrespondentPct value
     * @param float $correspondentPct
     * @return \Path\pathStructType\PathFeeData
     */
    public function setCorrespondentPct($correspondentPct = null)
    {
        $this->CorrespondentPct = $correspondentPct;
        return $this;
    }
    /**
     * Get CorrespondentPOCIndicator value
     * @return bool
     */
    public function getCorrespondentPOCIndicator()
    {
        return $this->CorrespondentPOCIndicator;
    }
    /**
     * Set CorrespondentPOCIndicator value
     * @param bool $correspondentPOCIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setCorrespondentPOCIndicator($correspondentPOCIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($correspondentPOCIndicator) && !is_bool($correspondentPOCIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($correspondentPOCIndicator)), __LINE__);
        }
        $this->CorrespondentPOCIndicator = $correspondentPOCIndicator;
        return $this;
    }
    /**
     * Get CustomFeeIndicator value
     * @return bool
     */
    public function getCustomFeeIndicator()
    {
        return $this->CustomFeeIndicator;
    }
    /**
     * Set CustomFeeIndicator value
     * @param bool $customFeeIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setCustomFeeIndicator($customFeeIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($customFeeIndicator) && !is_bool($customFeeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($customFeeIndicator)), __LINE__);
        }
        $this->CustomFeeIndicator = $customFeeIndicator;
        return $this;
    }
    /**
     * Get ExcludableIndicator value
     * @return bool
     */
    public function getExcludableIndicator()
    {
        return $this->ExcludableIndicator;
    }
    /**
     * Set ExcludableIndicator value
     * @param bool $excludableIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setExcludableIndicator($excludableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludableIndicator) && !is_bool($excludableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($excludableIndicator)), __LINE__);
        }
        $this->ExcludableIndicator = $excludableIndicator;
        return $this;
    }
    /**
     * Get ExcludeFromMortgageDeedIndicator value
     * @return bool
     */
    public function getExcludeFromMortgageDeedIndicator()
    {
        return $this->ExcludeFromMortgageDeedIndicator;
    }
    /**
     * Set ExcludeFromMortgageDeedIndicator value
     * @param bool $excludeFromMortgageDeedIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setExcludeFromMortgageDeedIndicator($excludeFromMortgageDeedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeFromMortgageDeedIndicator) && !is_bool($excludeFromMortgageDeedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($excludeFromMortgageDeedIndicator)), __LINE__);
        }
        $this->ExcludeFromMortgageDeedIndicator = $excludeFromMortgageDeedIndicator;
        return $this;
    }
    /**
     * Get FederalBonaFideIndicator value
     * @return bool
     */
    public function getFederalBonaFideIndicator()
    {
        return $this->FederalBonaFideIndicator;
    }
    /**
     * Set FederalBonaFideIndicator value
     * @param bool $federalBonaFideIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setFederalBonaFideIndicator($federalBonaFideIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($federalBonaFideIndicator) && !is_bool($federalBonaFideIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($federalBonaFideIndicator)), __LINE__);
        }
        $this->FederalBonaFideIndicator = $federalBonaFideIndicator;
        return $this;
    }
    /**
     * Get FHAAllowableIndicator value
     * @return bool
     */
    public function getFHAAllowableIndicator()
    {
        return $this->FHAAllowableIndicator;
    }
    /**
     * Set FHAAllowableIndicator value
     * @param bool $fHAAllowableIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setFHAAllowableIndicator($fHAAllowableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($fHAAllowableIndicator) && !is_bool($fHAAllowableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fHAAllowableIndicator)), __LINE__);
        }
        $this->FHAAllowableIndicator = $fHAAllowableIndicator;
        return $this;
    }
    /**
     * Get FinancedIndicator value
     * @return bool
     */
    public function getFinancedIndicator()
    {
        return $this->FinancedIndicator;
    }
    /**
     * Set FinancedIndicator value
     * @param bool $financedIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setFinancedIndicator($financedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($financedIndicator) && !is_bool($financedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($financedIndicator)), __LINE__);
        }
        $this->FinancedIndicator = $financedIndicator;
        return $this;
    }
    /**
     * Get GSEBonaFideIndicator value
     * @return bool
     */
    public function getGSEBonaFideIndicator()
    {
        return $this->GSEBonaFideIndicator;
    }
    /**
     * Set GSEBonaFideIndicator value
     * @param bool $gSEBonaFideIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setGSEBonaFideIndicator($gSEBonaFideIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($gSEBonaFideIndicator) && !is_bool($gSEBonaFideIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($gSEBonaFideIndicator)), __LINE__);
        }
        $this->GSEBonaFideIndicator = $gSEBonaFideIndicator;
        return $this;
    }
    /**
     * Get LenderAmt value
     * @return float
     */
    public function getLenderAmt()
    {
        return $this->LenderAmt;
    }
    /**
     * Set LenderAmt value
     * @param float $lenderAmt
     * @return \Path\pathStructType\PathFeeData
     */
    public function setLenderAmt($lenderAmt = null)
    {
        $this->LenderAmt = $lenderAmt;
        return $this;
    }
    /**
     * Get LenderPct value
     * @return float
     */
    public function getLenderPct()
    {
        return $this->LenderPct;
    }
    /**
     * Set LenderPct value
     * @param float $lenderPct
     * @return \Path\pathStructType\PathFeeData
     */
    public function setLenderPct($lenderPct = null)
    {
        $this->LenderPct = $lenderPct;
        return $this;
    }
    /**
     * Get LenderPOCIndicator value
     * @return bool
     */
    public function getLenderPOCIndicator()
    {
        return $this->LenderPOCIndicator;
    }
    /**
     * Set LenderPOCIndicator value
     * @param bool $lenderPOCIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setLenderPOCIndicator($lenderPOCIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($lenderPOCIndicator) && !is_bool($lenderPOCIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($lenderPOCIndicator)), __LINE__);
        }
        $this->LenderPOCIndicator = $lenderPOCIndicator;
        return $this;
    }
    /**
     * Get Percent value
     * @return float
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \Path\pathStructType\PathFeeData
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get POCIndicator value
     * @return bool
     */
    public function getPOCIndicator()
    {
        return $this->POCIndicator;
    }
    /**
     * Set POCIndicator value
     * @param bool $pOCIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setPOCIndicator($pOCIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($pOCIndicator) && !is_bool($pOCIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($pOCIndicator)), __LINE__);
        }
        $this->POCIndicator = $pOCIndicator;
        return $this;
    }
    /**
     * Get QMIndicator value
     * @return bool
     */
    public function getQMIndicator()
    {
        return $this->QMIndicator;
    }
    /**
     * Set QMIndicator value
     * @param bool $qMIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setQMIndicator($qMIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($qMIndicator) && !is_bool($qMIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($qMIndicator)), __LINE__);
        }
        $this->QMIndicator = $qMIndicator;
        return $this;
    }
    /**
     * Get SellerAmt value
     * @return float
     */
    public function getSellerAmt()
    {
        return $this->SellerAmt;
    }
    /**
     * Set SellerAmt value
     * @param float $sellerAmt
     * @return \Path\pathStructType\PathFeeData
     */
    public function setSellerAmt($sellerAmt = null)
    {
        $this->SellerAmt = $sellerAmt;
        return $this;
    }
    /**
     * Get SellerPct value
     * @return float
     */
    public function getSellerPct()
    {
        return $this->SellerPct;
    }
    /**
     * Set SellerPct value
     * @param float $sellerPct
     * @return \Path\pathStructType\PathFeeData
     */
    public function setSellerPct($sellerPct = null)
    {
        $this->SellerPct = $sellerPct;
        return $this;
    }
    /**
     * Get SellerPOCIndicator value
     * @return bool
     */
    public function getSellerPOCIndicator()
    {
        return $this->SellerPOCIndicator;
    }
    /**
     * Set SellerPOCIndicator value
     * @param bool $sellerPOCIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setSellerPOCIndicator($sellerPOCIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($sellerPOCIndicator) && !is_bool($sellerPOCIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sellerPOCIndicator)), __LINE__);
        }
        $this->SellerPOCIndicator = $sellerPOCIndicator;
        return $this;
    }
    /**
     * Get ShoppableIndicator value
     * @return bool
     */
    public function getShoppableIndicator()
    {
        return $this->ShoppableIndicator;
    }
    /**
     * Set ShoppableIndicator value
     * @param bool $shoppableIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setShoppableIndicator($shoppableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($shoppableIndicator) && !is_bool($shoppableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($shoppableIndicator)), __LINE__);
        }
        $this->ShoppableIndicator = $shoppableIndicator;
        return $this;
    }
    /**
     * Get SplitByAmt value
     * @return bool
     */
    public function getSplitByAmt()
    {
        return $this->SplitByAmt;
    }
    /**
     * Set SplitByAmt value
     * @param bool $splitByAmt
     * @return \Path\pathStructType\PathFeeData
     */
    public function setSplitByAmt($splitByAmt = null)
    {
        // validation for constraint: boolean
        if (!is_null($splitByAmt) && !is_bool($splitByAmt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($splitByAmt)), __LINE__);
        }
        $this->SplitByAmt = $splitByAmt;
        return $this;
    }
    /**
     * Get SplitByPct value
     * @return bool
     */
    public function getSplitByPct()
    {
        return $this->SplitByPct;
    }
    /**
     * Set SplitByPct value
     * @param bool $splitByPct
     * @return \Path\pathStructType\PathFeeData
     */
    public function setSplitByPct($splitByPct = null)
    {
        // validation for constraint: boolean
        if (!is_null($splitByPct) && !is_bool($splitByPct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($splitByPct)), __LINE__);
        }
        $this->SplitByPct = $splitByPct;
        return $this;
    }
    /**
     * Get StateBonaFideIndicator value
     * @return bool
     */
    public function getStateBonaFideIndicator()
    {
        return $this->StateBonaFideIndicator;
    }
    /**
     * Set StateBonaFideIndicator value
     * @param bool $stateBonaFideIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setStateBonaFideIndicator($stateBonaFideIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($stateBonaFideIndicator) && !is_bool($stateBonaFideIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($stateBonaFideIndicator)), __LINE__);
        }
        $this->StateBonaFideIndicator = $stateBonaFideIndicator;
        return $this;
    }
    /**
     * Get ThirdPartyAmt value
     * @return float
     */
    public function getThirdPartyAmt()
    {
        return $this->ThirdPartyAmt;
    }
    /**
     * Set ThirdPartyAmt value
     * @param float $thirdPartyAmt
     * @return \Path\pathStructType\PathFeeData
     */
    public function setThirdPartyAmt($thirdPartyAmt = null)
    {
        $this->ThirdPartyAmt = $thirdPartyAmt;
        return $this;
    }
    /**
     * Get ThirdPartyPct value
     * @return float
     */
    public function getThirdPartyPct()
    {
        return $this->ThirdPartyPct;
    }
    /**
     * Set ThirdPartyPct value
     * @param float $thirdPartyPct
     * @return \Path\pathStructType\PathFeeData
     */
    public function setThirdPartyPct($thirdPartyPct = null)
    {
        $this->ThirdPartyPct = $thirdPartyPct;
        return $this;
    }
    /**
     * Get ThirdPartyPOCIndicator value
     * @return bool
     */
    public function getThirdPartyPOCIndicator()
    {
        return $this->ThirdPartyPOCIndicator;
    }
    /**
     * Set ThirdPartyPOCIndicator value
     * @param bool $thirdPartyPOCIndicator
     * @return \Path\pathStructType\PathFeeData
     */
    public function setThirdPartyPOCIndicator($thirdPartyPOCIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($thirdPartyPOCIndicator) && !is_bool($thirdPartyPOCIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($thirdPartyPOCIndicator)), __LINE__);
        }
        $this->ThirdPartyPOCIndicator = $thirdPartyPOCIndicator;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \Path\pathStructType\PathFeeData
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \Path\pathStructType\PathFeeData
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get BasedOn value
     * @return string|null
     */
    public function getBasedOn()
    {
        return $this->BasedOn;
    }
    /**
     * Set BasedOn value
     * @param string $basedOn
     * @return \Path\pathStructType\PathFeeData
     */
    public function setBasedOn($basedOn = null)
    {
        // validation for constraint: string
        if (!is_null($basedOn) && !is_string($basedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($basedOn)), __LINE__);
        }
        $this->BasedOn = $basedOn;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Path\pathStructType\PathFeeData
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get COCDate value
     * @return string|null
     */
    public function getCOCDate()
    {
        return $this->COCDate;
    }
    /**
     * Set COCDate value
     * @param string $cOCDate
     * @return \Path\pathStructType\PathFeeData
     */
    public function setCOCDate($cOCDate = null)
    {
        // validation for constraint: string
        if (!is_null($cOCDate) && !is_string($cOCDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOCDate)), __LINE__);
        }
        $this->COCDate = $cOCDate;
        return $this;
    }
    /**
     * Get COCReason value
     * @return string|null
     */
    public function getCOCReason()
    {
        return $this->COCReason;
    }
    /**
     * Set COCReason value
     * @param string $cOCReason
     * @return \Path\pathStructType\PathFeeData
     */
    public function setCOCReason($cOCReason = null)
    {
        // validation for constraint: string
        if (!is_null($cOCReason) && !is_string($cOCReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOCReason)), __LINE__);
        }
        $this->COCReason = $cOCReason;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \Path\pathStructType\PathFeeData
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Contact value
     * @return string|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param string $contact
     * @return \Path\pathStructType\PathFeeData
     */
    public function setContact($contact = null)
    {
        // validation for constraint: string
        if (!is_null($contact) && !is_string($contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contact)), __LINE__);
        }
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get DailyInterestFromDate value
     * @return string|null
     */
    public function getDailyInterestFromDate()
    {
        return $this->DailyInterestFromDate;
    }
    /**
     * Set DailyInterestFromDate value
     * @param string $dailyInterestFromDate
     * @return \Path\pathStructType\PathFeeData
     */
    public function setDailyInterestFromDate($dailyInterestFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($dailyInterestFromDate) && !is_string($dailyInterestFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dailyInterestFromDate)), __LINE__);
        }
        $this->DailyInterestFromDate = $dailyInterestFromDate;
        return $this;
    }
    /**
     * Get DailyInterestToDate value
     * @return string|null
     */
    public function getDailyInterestToDate()
    {
        return $this->DailyInterestToDate;
    }
    /**
     * Set DailyInterestToDate value
     * @param string $dailyInterestToDate
     * @return \Path\pathStructType\PathFeeData
     */
    public function setDailyInterestToDate($dailyInterestToDate = null)
    {
        // validation for constraint: string
        if (!is_null($dailyInterestToDate) && !is_string($dailyInterestToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dailyInterestToDate)), __LINE__);
        }
        $this->DailyInterestToDate = $dailyInterestToDate;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \Path\pathStructType\PathFeeData
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get FeeName value
     * @return string|null
     */
    public function getFeeName()
    {
        return $this->FeeName;
    }
    /**
     * Set FeeName value
     * @param string $feeName
     * @return \Path\pathStructType\PathFeeData
     */
    public function setFeeName($feeName = null)
    {
        // validation for constraint: string
        if (!is_null($feeName) && !is_string($feeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feeName)), __LINE__);
        }
        $this->FeeName = $feeName;
        return $this;
    }
    /**
     * Get FeeSection value
     * @return string|null
     */
    public function getFeeSection()
    {
        return $this->FeeSection;
    }
    /**
     * Set FeeSection value
     * @param string $feeSection
     * @return \Path\pathStructType\PathFeeData
     */
    public function setFeeSection($feeSection = null)
    {
        // validation for constraint: string
        if (!is_null($feeSection) && !is_string($feeSection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feeSection)), __LINE__);
        }
        $this->FeeSection = $feeSection;
        return $this;
    }
    /**
     * Get FeeType value
     * @return string|null
     */
    public function getFeeType()
    {
        return $this->FeeType;
    }
    /**
     * Set FeeType value
     * @param string $feeType
     * @return \Path\pathStructType\PathFeeData
     */
    public function setFeeType($feeType = null)
    {
        // validation for constraint: string
        if (!is_null($feeType) && !is_string($feeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feeType)), __LINE__);
        }
        $this->FeeType = $feeType;
        return $this;
    }
    /**
     * Get Frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param string $frequency
     * @return \Path\pathStructType\PathFeeData
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: string
        if (!is_null($frequency) && !is_string($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($frequency)), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get MonthsCushion value
     * @return string|null
     */
    public function getMonthsCushion()
    {
        return $this->MonthsCushion;
    }
    /**
     * Set MonthsCushion value
     * @param string $monthsCushion
     * @return \Path\pathStructType\PathFeeData
     */
    public function setMonthsCushion($monthsCushion = null)
    {
        // validation for constraint: string
        if (!is_null($monthsCushion) && !is_string($monthsCushion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($monthsCushion)), __LINE__);
        }
        $this->MonthsCushion = $monthsCushion;
        return $this;
    }
    /**
     * Get NumberDays value
     * @return string|null
     */
    public function getNumberDays()
    {
        return $this->NumberDays;
    }
    /**
     * Set NumberDays value
     * @param string $numberDays
     * @return \Path\pathStructType\PathFeeData
     */
    public function setNumberDays($numberDays = null)
    {
        // validation for constraint: string
        if (!is_null($numberDays) && !is_string($numberDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberDays)), __LINE__);
        }
        $this->NumberDays = $numberDays;
        return $this;
    }
    /**
     * Get NumberMonths value
     * @return string|null
     */
    public function getNumberMonths()
    {
        return $this->NumberMonths;
    }
    /**
     * Set NumberMonths value
     * @param string $numberMonths
     * @return \Path\pathStructType\PathFeeData
     */
    public function setNumberMonths($numberMonths = null)
    {
        // validation for constraint: string
        if (!is_null($numberMonths) && !is_string($numberMonths)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberMonths)), __LINE__);
        }
        $this->NumberMonths = $numberMonths;
        return $this;
    }
    /**
     * Get PaidBy value
     * @return string|null
     */
    public function getPaidBy()
    {
        return $this->PaidBy;
    }
    /**
     * Set PaidBy value
     * @param string $paidBy
     * @return \Path\pathStructType\PathFeeData
     */
    public function setPaidBy($paidBy = null)
    {
        // validation for constraint: string
        if (!is_null($paidBy) && !is_string($paidBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paidBy)), __LINE__);
        }
        $this->PaidBy = $paidBy;
        return $this;
    }
    /**
     * Get PaidTo value
     * @return string|null
     */
    public function getPaidTo()
    {
        return $this->PaidTo;
    }
    /**
     * Set PaidTo value
     * @param string $paidTo
     * @return \Path\pathStructType\PathFeeData
     */
    public function setPaidTo($paidTo = null)
    {
        // validation for constraint: string
        if (!is_null($paidTo) && !is_string($paidTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paidTo)), __LINE__);
        }
        $this->PaidTo = $paidTo;
        return $this;
    }
    /**
     * Get PaidToCompany value
     * @return string|null
     */
    public function getPaidToCompany()
    {
        return $this->PaidToCompany;
    }
    /**
     * Set PaidToCompany value
     * @param string $paidToCompany
     * @return \Path\pathStructType\PathFeeData
     */
    public function setPaidToCompany($paidToCompany = null)
    {
        // validation for constraint: string
        if (!is_null($paidToCompany) && !is_string($paidToCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paidToCompany)), __LINE__);
        }
        $this->PaidToCompany = $paidToCompany;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \Path\pathStructType\PathFeeData
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get PrepaidType value
     * @return string|null
     */
    public function getPrepaidType()
    {
        return $this->PrepaidType;
    }
    /**
     * Set PrepaidType value
     * @param string $prepaidType
     * @return \Path\pathStructType\PathFeeData
     */
    public function setPrepaidType($prepaidType = null)
    {
        // validation for constraint: string
        if (!is_null($prepaidType) && !is_string($prepaidType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prepaidType)), __LINE__);
        }
        $this->PrepaidType = $prepaidType;
        return $this;
    }
    /**
     * Get ServiceProviderSourceType value
     * @return string|null
     */
    public function getServiceProviderSourceType()
    {
        return $this->ServiceProviderSourceType;
    }
    /**
     * Set ServiceProviderSourceType value
     * @param string $serviceProviderSourceType
     * @return \Path\pathStructType\PathFeeData
     */
    public function setServiceProviderSourceType($serviceProviderSourceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderSourceType) && !is_string($serviceProviderSourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderSourceType)), __LINE__);
        }
        $this->ServiceProviderSourceType = $serviceProviderSourceType;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \Path\pathStructType\PathFeeData
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get WithholdFromWire value
     * @return string|null
     */
    public function getWithholdFromWire()
    {
        return $this->WithholdFromWire;
    }
    /**
     * Set WithholdFromWire value
     * @param string $withholdFromWire
     * @return \Path\pathStructType\PathFeeData
     */
    public function setWithholdFromWire($withholdFromWire = null)
    {
        // validation for constraint: string
        if (!is_null($withholdFromWire) && !is_string($withholdFromWire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($withholdFromWire)), __LINE__);
        }
        $this->WithholdFromWire = $withholdFromWire;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \Path\pathStructType\PathFeeData
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Path\pathStructType\PathFeeData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
