<?php

namespace Path\pathArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLoanKeyValuePair pathArrayType
 * @package Path
 * @subpackage Arrays
 */
class PathArrayOfLoanKeyValuePair extends AbstractStructArrayBase
{
    /**
     * The Values
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Path\pathStructType\PathLoanKeyValuePair[]
     */
    public $Values;
    /**
     * Constructor method for ArrayOfLoanKeyValuePair
     * @uses PathArrayOfLoanKeyValuePair::setValues()
     * @param \Path\pathStructType\PathLoanKeyValuePair[] $values
     */
    public function __construct(array $values = array())
    {
        $this
            ->setValues($values);
    }
    /**
     * Get Values value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Path\pathStructType\PathLoanKeyValuePair[]|null
     */
    public function getValues()
    {
        return isset($this->Values) ? $this->Values : null;
    }
    /**
     * Set Values value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathLoanKeyValuePair[] $values
     * @return \Path\pathArrayType\PathArrayOfLoanKeyValuePair
     */
    public function setValues(array $values = array())
    {
        foreach ($values as $arrayOfLoanKeyValuePairValuesItem) {
            // validation for constraint: itemType
            if (!$arrayOfLoanKeyValuePairValuesItem instanceof \Path\pathStructType\PathLoanKeyValuePair) {
                throw new \InvalidArgumentException(sprintf('The Values property can only contain items of \Path\pathStructType\PathLoanKeyValuePair, "%s" given', is_object($arrayOfLoanKeyValuePairValuesItem) ? get_class($arrayOfLoanKeyValuePairValuesItem) : gettype($arrayOfLoanKeyValuePairValuesItem)), __LINE__);
            }
        }
        if (is_null($values) || (is_array($values) && empty($values))) {
            unset($this->Values);
        } else {
            $this->Values = $values;
        }
        return $this;
    }
    /**
     * Add item to Values value
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathLoanKeyValuePair $item
     * @return \Path\pathArrayType\PathArrayOfLoanKeyValuePair
     */
    public function addToValues(\Path\pathStructType\PathLoanKeyValuePair $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Path\pathStructType\PathLoanKeyValuePair) {
            throw new \InvalidArgumentException(sprintf('The Values property can only contain items of \Path\pathStructType\PathLoanKeyValuePair, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Values[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Path\pathStructType\PathLoanKeyValuePair|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Path\pathStructType\PathLoanKeyValuePair|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Path\pathStructType\PathLoanKeyValuePair|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Path\pathStructType\PathLoanKeyValuePair|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Path\pathStructType\PathLoanKeyValuePair|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Values
     */
    public function getAttributeName()
    {
        return 'Values';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Path\pathArrayType\PathArrayOfLoanKeyValuePair
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
