<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDocumentFile pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathGetDocumentFile extends AbstractStructBase
{
    /**
     * The docid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $docid;
    /**
     * The vendorid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorid;
    /**
     * The apitoken
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $apitoken;
    /**
     * The vendorpw
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorpw;
    /**
     * Constructor method for GetDocumentFile
     * @uses PathGetDocumentFile::setDocid()
     * @uses PathGetDocumentFile::setVendorid()
     * @uses PathGetDocumentFile::setApitoken()
     * @uses PathGetDocumentFile::setVendorpw()
     * @param int $docid
     * @param string $vendorid
     * @param string $apitoken
     * @param string $vendorpw
     */
    public function __construct($docid = null, $vendorid = null, $apitoken = null, $vendorpw = null)
    {
        $this
            ->setDocid($docid)
            ->setVendorid($vendorid)
            ->setApitoken($apitoken)
            ->setVendorpw($vendorpw);
    }
    /**
     * Get docid value
     * @return int
     */
    public function getDocid()
    {
        return $this->docid;
    }
    /**
     * Set docid value
     * @param int $docid
     * @return \Path\pathStructType\PathGetDocumentFile
     */
    public function setDocid($docid = null)
    {
        // validation for constraint: int
        if (!is_null($docid) && !is_numeric($docid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($docid)), __LINE__);
        }
        $this->docid = $docid;
        return $this;
    }
    /**
     * Get vendorid value
     * @return string|null
     */
    public function getVendorid()
    {
        return $this->vendorid;
    }
    /**
     * Set vendorid value
     * @param string $vendorid
     * @return \Path\pathStructType\PathGetDocumentFile
     */
    public function setVendorid($vendorid = null)
    {
        // validation for constraint: string
        if (!is_null($vendorid) && !is_string($vendorid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorid)), __LINE__);
        }
        $this->vendorid = $vendorid;
        return $this;
    }
    /**
     * Get apitoken value
     * @return string|null
     */
    public function getApitoken()
    {
        return $this->apitoken;
    }
    /**
     * Set apitoken value
     * @param string $apitoken
     * @return \Path\pathStructType\PathGetDocumentFile
     */
    public function setApitoken($apitoken = null)
    {
        // validation for constraint: string
        if (!is_null($apitoken) && !is_string($apitoken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apitoken)), __LINE__);
        }
        $this->apitoken = $apitoken;
        return $this;
    }
    /**
     * Get vendorpw value
     * @return string|null
     */
    public function getVendorpw()
    {
        return $this->vendorpw;
    }
    /**
     * Set vendorpw value
     * @param string $vendorpw
     * @return \Path\pathStructType\PathGetDocumentFile
     */
    public function setVendorpw($vendorpw = null)
    {
        // validation for constraint: string
        if (!is_null($vendorpw) && !is_string($vendorpw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorpw)), __LINE__);
        }
        $this->vendorpw = $vendorpw;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Path\pathStructType\PathGetDocumentFile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
