<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentInfo pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathDocumentInfo extends AbstractStructBase
{
    /**
     * The docid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $docid;
    /**
     * The documentname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documentname;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The documenttype
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documenttype;
    /**
     * Constructor method for DocumentInfo
     * @uses PathDocumentInfo::setDocid()
     * @uses PathDocumentInfo::setDocumentname()
     * @uses PathDocumentInfo::setDescription()
     * @uses PathDocumentInfo::setDocumenttype()
     * @param int $docid
     * @param string $documentname
     * @param string $description
     * @param string $documenttype
     */
    public function __construct($docid = null, $documentname = null, $description = null, $documenttype = null)
    {
        $this
            ->setDocid($docid)
            ->setDocumentname($documentname)
            ->setDescription($description)
            ->setDocumenttype($documenttype);
    }
    /**
     * Get docid value
     * @return int
     */
    public function getDocid()
    {
        return $this->docid;
    }
    /**
     * Set docid value
     * @param int $docid
     * @return \Path\pathStructType\PathDocumentInfo
     */
    public function setDocid($docid = null)
    {
        // validation for constraint: int
        if (!is_null($docid) && !is_numeric($docid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($docid)), __LINE__);
        }
        $this->docid = $docid;
        return $this;
    }
    /**
     * Get documentname value
     * @return string|null
     */
    public function getDocumentname()
    {
        return $this->documentname;
    }
    /**
     * Set documentname value
     * @param string $documentname
     * @return \Path\pathStructType\PathDocumentInfo
     */
    public function setDocumentname($documentname = null)
    {
        // validation for constraint: string
        if (!is_null($documentname) && !is_string($documentname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentname)), __LINE__);
        }
        $this->documentname = $documentname;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Path\pathStructType\PathDocumentInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get documenttype value
     * @return string|null
     */
    public function getDocumenttype()
    {
        return $this->documenttype;
    }
    /**
     * Set documenttype value
     * @param string $documenttype
     * @return \Path\pathStructType\PathDocumentInfo
     */
    public function setDocumenttype($documenttype = null)
    {
        // validation for constraint: string
        if (!is_null($documenttype) && !is_string($documenttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documenttype)), __LINE__);
        }
        $this->documenttype = $documenttype;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Path\pathStructType\PathDocumentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
