<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultDocList pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultDocList extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The docinfolist
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfDocumentInfo
     */
    public $docinfolist;
    /**
     * Constructor method for ResultDocList
     * @uses PathResultDocList::setStatus()
     * @uses PathResultDocList::setMessage()
     * @uses PathResultDocList::setDocinfolist()
     * @param int $status
     * @param string $message
     * @param \Path\pathArrayType\PathArrayOfDocumentInfo $docinfolist
     */
    public function __construct($status = null, $message = null, \Path\pathArrayType\PathArrayOfDocumentInfo $docinfolist = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setDocinfolist($docinfolist);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultDocList
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Path\pathStructType\PathResultDocList
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get docinfolist value
     * @return \Path\pathArrayType\PathArrayOfDocumentInfo|null
     */
    public function getDocinfolist()
    {
        return $this->docinfolist;
    }
    /**
     * Set docinfolist value
     * @param \Path\pathArrayType\PathArrayOfDocumentInfo $docinfolist
     * @return \Path\pathStructType\PathResultDocList
     */
    public function setDocinfolist(\Path\pathArrayType\PathArrayOfDocumentInfo $docinfolist = null)
    {
        $this->docinfolist = $docinfolist;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Path\pathStructType\PathResultDocList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
