<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultDocFile pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultDocFile extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The docinfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathStructType\PathDocumentInfo
     */
    public $docinfo;
    /**
     * The documentfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documentfile;
    /**
     * Constructor method for ResultDocFile
     * @uses PathResultDocFile::setStatus()
     * @uses PathResultDocFile::setMessage()
     * @uses PathResultDocFile::setDocinfo()
     * @uses PathResultDocFile::setDocumentfile()
     * @param int $status
     * @param string $message
     * @param \Path\pathStructType\PathDocumentInfo $docinfo
     * @param string $documentfile
     */
    public function __construct($status = null, $message = null, \Path\pathStructType\PathDocumentInfo $docinfo = null, $documentfile = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setDocinfo($docinfo)
            ->setDocumentfile($documentfile);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultDocFile
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Path\pathStructType\PathResultDocFile
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get docinfo value
     * @return \Path\pathStructType\PathDocumentInfo|null
     */
    public function getDocinfo()
    {
        return $this->docinfo;
    }
    /**
     * Set docinfo value
     * @param \Path\pathStructType\PathDocumentInfo $docinfo
     * @return \Path\pathStructType\PathResultDocFile
     */
    public function setDocinfo(\Path\pathStructType\PathDocumentInfo $docinfo = null)
    {
        $this->docinfo = $docinfo;
        return $this;
    }
    /**
     * Get documentfile value
     * @return string|null
     */
    public function getDocumentfile()
    {
        return $this->documentfile;
    }
    /**
     * Set documentfile value
     * @param string $documentfile
     * @return \Path\pathStructType\PathResultDocFile
     */
    public function setDocumentfile($documentfile = null)
    {
        // validation for constraint: string
        if (!is_null($documentfile) && !is_string($documentfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentfile)), __LINE__);
        }
        $this->documentfile = $documentfile;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Path\pathStructType\PathResultDocFile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
