<?php

namespace Path\pathServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update pathServiceType
 * @package Path
 * @subpackage Services
 */
class PathUpdate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateLoanFeeData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathUpdateLoanFeeData $parameters
     * @return \Path\pathStructType\PathUpdateLoanFeeDataResponse|bool
     */
    public function UpdateLoanFeeData(\Path\pathStructType\PathUpdateLoanFeeData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateLoanFeeData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Path\pathStructType\PathUpdateLoanFeeDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
