<?php

namespace Path\pathServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Extend pathServiceType
 * @package Path
 * @subpackage Services
 */
class PathExtend extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ExtendTheToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathExtendTheToken $parameters
     * @return \Path\pathStructType\PathExtendTheTokenResponse|bool
     */
    public function ExtendTheToken(\Path\pathStructType\PathExtendTheToken $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExtendTheToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Path\pathStructType\PathExtendTheTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
