<?php

namespace Path\pathArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLoanKeyValuePair1 pathArrayType
 * @package Path
 * @subpackage Arrays
 */
class PathArrayOfLoanKeyValuePair1 extends AbstractStructArrayBase
{
    /**
     * The LoanKeyValuePair
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Path\pathStructType\PathLoanKeyValuePair[]
     */
    public $LoanKeyValuePair;
    /**
     * Constructor method for ArrayOfLoanKeyValuePair1
     * @uses PathArrayOfLoanKeyValuePair1::setLoanKeyValuePair()
     * @param \Path\pathStructType\PathLoanKeyValuePair[] $loanKeyValuePair
     */
    public function __construct(array $loanKeyValuePair = array())
    {
        $this
            ->setLoanKeyValuePair($loanKeyValuePair);
    }
    /**
     * Get LoanKeyValuePair value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Path\pathStructType\PathLoanKeyValuePair[]|null
     */
    public function getLoanKeyValuePair()
    {
        return isset($this->LoanKeyValuePair) ? $this->LoanKeyValuePair : null;
    }
    /**
     * Set LoanKeyValuePair value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathLoanKeyValuePair[] $loanKeyValuePair
     * @return \Path\pathArrayType\PathArrayOfLoanKeyValuePair1
     */
    public function setLoanKeyValuePair(array $loanKeyValuePair = array())
    {
        foreach ($loanKeyValuePair as $arrayOfLoanKeyValuePair1LoanKeyValuePairItem) {
            // validation for constraint: itemType
            if (!$arrayOfLoanKeyValuePair1LoanKeyValuePairItem instanceof \Path\pathStructType\PathLoanKeyValuePair) {
                throw new \InvalidArgumentException(sprintf('The LoanKeyValuePair property can only contain items of \Path\pathStructType\PathLoanKeyValuePair, "%s" given', is_object($arrayOfLoanKeyValuePair1LoanKeyValuePairItem) ? get_class($arrayOfLoanKeyValuePair1LoanKeyValuePairItem) : gettype($arrayOfLoanKeyValuePair1LoanKeyValuePairItem)), __LINE__);
            }
        }
        if (is_null($loanKeyValuePair) || (is_array($loanKeyValuePair) && empty($loanKeyValuePair))) {
            unset($this->LoanKeyValuePair);
        } else {
            $this->LoanKeyValuePair = $loanKeyValuePair;
        }
        return $this;
    }
    /**
     * Add item to LoanKeyValuePair value
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathLoanKeyValuePair $item
     * @return \Path\pathArrayType\PathArrayOfLoanKeyValuePair1
     */
    public function addToLoanKeyValuePair(\Path\pathStructType\PathLoanKeyValuePair $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Path\pathStructType\PathLoanKeyValuePair) {
            throw new \InvalidArgumentException(sprintf('The LoanKeyValuePair property can only contain items of \Path\pathStructType\PathLoanKeyValuePair, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoanKeyValuePair[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Path\pathStructType\PathLoanKeyValuePair|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Path\pathStructType\PathLoanKeyValuePair|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Path\pathStructType\PathLoanKeyValuePair|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Path\pathStructType\PathLoanKeyValuePair|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Path\pathStructType\PathLoanKeyValuePair|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LoanKeyValuePair
     */
    public function getAttributeName()
    {
        return 'LoanKeyValuePair';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Path\pathArrayType\PathArrayOfLoanKeyValuePair1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
