<?php

namespace Path\pathServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete pathServiceType
 * @package Path
 * @subpackage Services
 */
class PathDelete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeleteLoanFeeData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathDeleteLoanFeeData $parameters
     * @return \Path\pathStructType\PathDeleteLoanFeeDataResponse|bool
     */
    public function DeleteLoanFeeData(\Path\pathStructType\PathDeleteLoanFeeData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteLoanFeeData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Path\pathStructType\PathDeleteLoanFeeDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
