<?php

namespace juniper\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginData StructType
 * @subpackage Structs
 */
class LoginData extends AbstractStructBase
{
    /**
     * The Extras
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \juniper\ArrayType\ArrayOfParamType
     */
    public $Extras;
    /**
     * The Email
     * @var string
     */
    public $Email;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * Constructor method for LoginData
     * @uses LoginData::setExtras()
     * @uses LoginData::setEmail()
     * @uses LoginData::setPassword()
     * @param \juniper\ArrayType\ArrayOfParamType $extras
     * @param string $email
     * @param string $password
     */
    public function __construct(\juniper\ArrayType\ArrayOfParamType $extras = null, $email = null, $password = null)
    {
        $this
            ->setExtras($extras)
            ->setEmail($email)
            ->setPassword($password);
    }
    /**
     * Get Extras value
     * @return \juniper\ArrayType\ArrayOfParamType|null
     */
    public function getExtras()
    {
        return $this->Extras;
    }
    /**
     * Set Extras value
     * @param \juniper\ArrayType\ArrayOfParamType $extras
     * @return \juniper\StructType\LoginData
     */
    public function setExtras(\juniper\ArrayType\ArrayOfParamType $extras = null)
    {
        $this->Extras = $extras;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \juniper\StructType\LoginData
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \juniper\StructType\LoginData
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \juniper\StructType\LoginData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
