<?php

namespace juniper\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElementType StructType
 * Meta informations extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class ElementType extends AbstractStructBase
{
    /**
     * The Extras
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \juniper\ArrayType\ArrayOfParamType
     */
    public $Extras;
    /**
     * The Id
     * @var int
     */
    public $Id;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Category
     * @var string
     */
    public $Category;
    /**
     * Constructor method for ElementType
     * @uses ElementType::setExtras()
     * @uses ElementType::setId()
     * @uses ElementType::setCode()
     * @uses ElementType::setCategory()
     * @param \juniper\ArrayType\ArrayOfParamType $extras
     * @param int $id
     * @param string $code
     * @param string $category
     */
    public function __construct(\juniper\ArrayType\ArrayOfParamType $extras = null, $id = null, $code = null, $category = null)
    {
        $this
            ->setExtras($extras)
            ->setId($id)
            ->setCode($code)
            ->setCategory($category);
    }
    /**
     * Get Extras value
     * @return \juniper\ArrayType\ArrayOfParamType|null
     */
    public function getExtras()
    {
        return $this->Extras;
    }
    /**
     * Set Extras value
     * @param \juniper\ArrayType\ArrayOfParamType $extras
     * @return \juniper\StructType\ElementType
     */
    public function setExtras(\juniper\ArrayType\ArrayOfParamType $extras = null)
    {
        $this->Extras = $extras;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \juniper\StructType\ElementType
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \juniper\StructType\ElementType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \juniper\StructType\ElementType
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \juniper\StructType\ElementType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
