<?php

namespace juniper\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataResult StructType
 * @subpackage Structs
 */
class DataResult extends AbstractStructBase
{
    /**
     * The Extras
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \juniper\ArrayType\ArrayOfParamType
     */
    public $Extras;
    /**
     * The Elements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \juniper\ArrayType\ArrayOfElementType
     */
    public $Elements;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for DataResult
     * @uses DataResult::setExtras()
     * @uses DataResult::setElements()
     * @uses DataResult::setType()
     * @param \juniper\ArrayType\ArrayOfParamType $extras
     * @param \juniper\ArrayType\ArrayOfElementType $elements
     * @param string $type
     */
    public function __construct(\juniper\ArrayType\ArrayOfParamType $extras = null, \juniper\ArrayType\ArrayOfElementType $elements = null, $type = null)
    {
        $this
            ->setExtras($extras)
            ->setElements($elements)
            ->setType($type);
    }
    /**
     * Get Extras value
     * @return \juniper\ArrayType\ArrayOfParamType|null
     */
    public function getExtras()
    {
        return $this->Extras;
    }
    /**
     * Set Extras value
     * @param \juniper\ArrayType\ArrayOfParamType $extras
     * @return \juniper\StructType\DataResult
     */
    public function setExtras(\juniper\ArrayType\ArrayOfParamType $extras = null)
    {
        $this->Extras = $extras;
        return $this;
    }
    /**
     * Get Elements value
     * @return \juniper\ArrayType\ArrayOfElementType|null
     */
    public function getElements()
    {
        return $this->Elements;
    }
    /**
     * Set Elements value
     * @param \juniper\ArrayType\ArrayOfElementType $elements
     * @return \juniper\StructType\DataResult
     */
    public function setElements(\juniper\ArrayType\ArrayOfElementType $elements = null)
    {
        $this->Elements = $elements;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \juniper\StructType\DataResult
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \juniper\StructType\DataResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
