<?php

namespace juniper\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCatalogueService
     * Meta informations extracted from the WSDL
     * - documentation: Gets the specified catalogue data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \juniper\StructType\GetCatalogueService $parameters
     * @return \juniper\StructType\GetCatalogueServiceResponse|bool
     */
    public function GetCatalogueService(\juniper\StructType\GetCatalogueService $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCatalogueService($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \juniper\StructType\GetCatalogueServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
