<?php

namespace juniper\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfParamType ArrayType
 * @subpackage Arrays
 */
class ArrayOfParamType extends AbstractStructArrayBase
{
    /**
     * The Extra
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \juniper\StructType\ParamType[]
     */
    public $Extra;
    /**
     * Constructor method for ArrayOfParamType
     * @uses ArrayOfParamType::setExtra()
     * @param \juniper\StructType\ParamType[] $extra
     */
    public function __construct(array $extra = array())
    {
        $this
            ->setExtra($extra);
    }
    /**
     * Get Extra value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \juniper\StructType\ParamType[]|null
     */
    public function getExtra()
    {
        return isset($this->Extra) ? $this->Extra : null;
    }
    /**
     * Set Extra value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \juniper\StructType\ParamType[] $extra
     * @return \juniper\ArrayType\ArrayOfParamType
     */
    public function setExtra(array $extra = array())
    {
        foreach ($extra as $arrayOfParamTypeExtraItem) {
            // validation for constraint: itemType
            if (!$arrayOfParamTypeExtraItem instanceof \juniper\StructType\ParamType) {
                throw new \InvalidArgumentException(sprintf('The Extra property can only contain items of \juniper\StructType\ParamType, "%s" given', is_object($arrayOfParamTypeExtraItem) ? get_class($arrayOfParamTypeExtraItem) : gettype($arrayOfParamTypeExtraItem)), __LINE__);
            }
        }
        if (is_null($extra) || (is_array($extra) && empty($extra))) {
            unset($this->Extra);
        } else {
            $this->Extra = $extra;
        }
        return $this;
    }
    /**
     * Add item to Extra value
     * @throws \InvalidArgumentException
     * @param \juniper\StructType\ParamType $item
     * @return \juniper\ArrayType\ArrayOfParamType
     */
    public function addToExtra(\juniper\StructType\ParamType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \juniper\StructType\ParamType) {
            throw new \InvalidArgumentException(sprintf('The Extra property can only contain items of \juniper\StructType\ParamType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Extra[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \juniper\StructType\ParamType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \juniper\StructType\ParamType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \juniper\StructType\ParamType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \juniper\StructType\ParamType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \juniper\StructType\ParamType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Extra
     */
    public function getAttributeName()
    {
        return 'Extra';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \juniper\ArrayType\ArrayOfParamType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
