<?php

namespace juniper\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfElementType ArrayType
 * @subpackage Arrays
 */
class ArrayOfElementType extends AbstractStructArrayBase
{
    /**
     * The Element
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \juniper\StructType\ElementType[]
     */
    public $Element;
    /**
     * Constructor method for ArrayOfElementType
     * @uses ArrayOfElementType::setElement()
     * @param \juniper\StructType\ElementType[] $element
     */
    public function __construct(array $element = array())
    {
        $this
            ->setElement($element);
    }
    /**
     * Get Element value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \juniper\StructType\ElementType[]|null
     */
    public function getElement()
    {
        return isset($this->Element) ? $this->Element : null;
    }
    /**
     * Set Element value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \juniper\StructType\ElementType[] $element
     * @return \juniper\ArrayType\ArrayOfElementType
     */
    public function setElement(array $element = array())
    {
        foreach ($element as $arrayOfElementTypeElementItem) {
            // validation for constraint: itemType
            if (!$arrayOfElementTypeElementItem instanceof \juniper\StructType\ElementType) {
                throw new \InvalidArgumentException(sprintf('The Element property can only contain items of \juniper\StructType\ElementType, "%s" given', is_object($arrayOfElementTypeElementItem) ? get_class($arrayOfElementTypeElementItem) : gettype($arrayOfElementTypeElementItem)), __LINE__);
            }
        }
        if (is_null($element) || (is_array($element) && empty($element))) {
            unset($this->Element);
        } else {
            $this->Element = $element;
        }
        return $this;
    }
    /**
     * Add item to Element value
     * @throws \InvalidArgumentException
     * @param \juniper\StructType\ElementType $item
     * @return \juniper\ArrayType\ArrayOfElementType
     */
    public function addToElement(\juniper\StructType\ElementType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \juniper\StructType\ElementType) {
            throw new \InvalidArgumentException(sprintf('The Element property can only contain items of \juniper\StructType\ElementType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Element[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \juniper\StructType\ElementType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \juniper\StructType\ElementType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \juniper\StructType\ElementType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \juniper\StructType\ElementType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \juniper\StructType\ElementType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Element
     */
    public function getAttributeName()
    {
        return 'Element';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \juniper\ArrayType\ArrayOfElementType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
