<?php

namespace juniper\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDataType ArrayType
 * @subpackage Arrays
 */
class ArrayOfDataType extends AbstractStructArrayBase
{
    /**
     * The DataTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \juniper\StructType\DataType[]
     */
    public $DataTypes;
    /**
     * Constructor method for ArrayOfDataType
     * @uses ArrayOfDataType::setDataTypes()
     * @param \juniper\StructType\DataType[] $dataTypes
     */
    public function __construct(array $dataTypes = array())
    {
        $this
            ->setDataTypes($dataTypes);
    }
    /**
     * Get DataTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \juniper\StructType\DataType[]|null
     */
    public function getDataTypes()
    {
        return isset($this->DataTypes) ? $this->DataTypes : null;
    }
    /**
     * Set DataTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \juniper\StructType\DataType[] $dataTypes
     * @return \juniper\ArrayType\ArrayOfDataType
     */
    public function setDataTypes(array $dataTypes = array())
    {
        foreach ($dataTypes as $arrayOfDataTypeDataTypesItem) {
            // validation for constraint: itemType
            if (!$arrayOfDataTypeDataTypesItem instanceof \juniper\StructType\DataType) {
                throw new \InvalidArgumentException(sprintf('The DataTypes property can only contain items of \juniper\StructType\DataType, "%s" given', is_object($arrayOfDataTypeDataTypesItem) ? get_class($arrayOfDataTypeDataTypesItem) : gettype($arrayOfDataTypeDataTypesItem)), __LINE__);
            }
        }
        if (is_null($dataTypes) || (is_array($dataTypes) && empty($dataTypes))) {
            unset($this->DataTypes);
        } else {
            $this->DataTypes = $dataTypes;
        }
        return $this;
    }
    /**
     * Add item to DataTypes value
     * @throws \InvalidArgumentException
     * @param \juniper\StructType\DataType $item
     * @return \juniper\ArrayType\ArrayOfDataType
     */
    public function addToDataTypes(\juniper\StructType\DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \juniper\StructType\DataType) {
            throw new \InvalidArgumentException(sprintf('The DataTypes property can only contain items of \juniper\StructType\DataType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DataTypes[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \juniper\StructType\DataType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \juniper\StructType\DataType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \juniper\StructType\DataType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \juniper\StructType\DataType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \juniper\StructType\DataType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DataTypes
     */
    public function getAttributeName()
    {
        return 'DataTypes';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \juniper\ArrayType\ArrayOfDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
