<?php

namespace juniper\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDataResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfDataResult extends AbstractStructArrayBase
{
    /**
     * The Result
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \juniper\StructType\DataResult[]
     */
    public $Result;
    /**
     * Constructor method for ArrayOfDataResult
     * @uses ArrayOfDataResult::setResult()
     * @param \juniper\StructType\DataResult[] $result
     */
    public function __construct(array $result = array())
    {
        $this
            ->setResult($result);
    }
    /**
     * Get Result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \juniper\StructType\DataResult[]|null
     */
    public function getResult()
    {
        return isset($this->Result) ? $this->Result : null;
    }
    /**
     * Set Result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \juniper\StructType\DataResult[] $result
     * @return \juniper\ArrayType\ArrayOfDataResult
     */
    public function setResult(array $result = array())
    {
        foreach ($result as $arrayOfDataResultResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfDataResultResultItem instanceof \juniper\StructType\DataResult) {
                throw new \InvalidArgumentException(sprintf('The Result property can only contain items of \juniper\StructType\DataResult, "%s" given', is_object($arrayOfDataResultResultItem) ? get_class($arrayOfDataResultResultItem) : gettype($arrayOfDataResultResultItem)), __LINE__);
            }
        }
        if (is_null($result) || (is_array($result) && empty($result))) {
            unset($this->Result);
        } else {
            $this->Result = $result;
        }
        return $this;
    }
    /**
     * Add item to Result value
     * @throws \InvalidArgumentException
     * @param \juniper\StructType\DataResult $item
     * @return \juniper\ArrayType\ArrayOfDataResult
     */
    public function addToResult(\juniper\StructType\DataResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \juniper\StructType\DataResult) {
            throw new \InvalidArgumentException(sprintf('The Result property can only contain items of \juniper\StructType\DataResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Result[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \juniper\StructType\DataResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \juniper\StructType\DataResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \juniper\StructType\DataResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \juniper\StructType\DataResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \juniper\StructType\DataResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Result
     */
    public function getAttributeName()
    {
        return 'Result';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \juniper\ArrayType\ArrayOfDataResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
