<?php

namespace juniper\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CatalogueDataRQ StructType
 * @subpackage Structs
 */
class CatalogueDataRQ extends AbstractStructBase
{
    /**
     * The Login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \juniper\StructType\LoginData
     */
    public $Login;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \juniper\ArrayType\ArrayOfDataType
     */
    public $Data;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * Constructor method for CatalogueDataRQ
     * @uses CatalogueDataRQ::setLogin()
     * @uses CatalogueDataRQ::setData()
     * @uses CatalogueDataRQ::setLanguage()
     * @uses CatalogueDataRQ::setVersion()
     * @param \juniper\StructType\LoginData $login
     * @param \juniper\ArrayType\ArrayOfDataType $data
     * @param string $language
     * @param string $version
     */
    public function __construct(\juniper\StructType\LoginData $login = null, \juniper\ArrayType\ArrayOfDataType $data = null, $language = null, $version = null)
    {
        $this
            ->setLogin($login)
            ->setData($data)
            ->setLanguage($language)
            ->setVersion($version);
    }
    /**
     * Get Login value
     * @return \juniper\StructType\LoginData|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \juniper\StructType\LoginData $login
     * @return \juniper\StructType\CatalogueDataRQ
     */
    public function setLogin(\juniper\StructType\LoginData $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get Data value
     * @return \juniper\ArrayType\ArrayOfDataType|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param \juniper\ArrayType\ArrayOfDataType $data
     * @return \juniper\StructType\CatalogueDataRQ
     */
    public function setData(\juniper\ArrayType\ArrayOfDataType $data = null)
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \juniper\StructType\CatalogueDataRQ
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \juniper\StructType\CatalogueDataRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \juniper\StructType\CatalogueDataRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
