<?php

namespace juniper\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWarningType ArrayType
 * @subpackage Arrays
 */
class ArrayOfWarningType extends AbstractStructArrayBase
{
    /**
     * The Warning
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \juniper\StructType\WarningType[]
     */
    public $Warning;
    /**
     * Constructor method for ArrayOfWarningType
     * @uses ArrayOfWarningType::setWarning()
     * @param \juniper\StructType\WarningType[] $warning
     */
    public function __construct(array $warning = array())
    {
        $this
            ->setWarning($warning);
    }
    /**
     * Get Warning value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \juniper\StructType\WarningType[]|null
     */
    public function getWarning()
    {
        return isset($this->Warning) ? $this->Warning : null;
    }
    /**
     * Set Warning value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \juniper\StructType\WarningType[] $warning
     * @return \juniper\ArrayType\ArrayOfWarningType
     */
    public function setWarning(array $warning = array())
    {
        foreach ($warning as $arrayOfWarningTypeWarningItem) {
            // validation for constraint: itemType
            if (!$arrayOfWarningTypeWarningItem instanceof \juniper\StructType\WarningType) {
                throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of \juniper\StructType\WarningType, "%s" given', is_object($arrayOfWarningTypeWarningItem) ? get_class($arrayOfWarningTypeWarningItem) : gettype($arrayOfWarningTypeWarningItem)), __LINE__);
            }
        }
        if (is_null($warning) || (is_array($warning) && empty($warning))) {
            unset($this->Warning);
        } else {
            $this->Warning = $warning;
        }
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \juniper\StructType\WarningType $item
     * @return \juniper\ArrayType\ArrayOfWarningType
     */
    public function addToWarning(\juniper\StructType\WarningType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \juniper\StructType\WarningType) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of \juniper\StructType\WarningType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \juniper\StructType\WarningType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \juniper\StructType\WarningType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \juniper\StructType\WarningType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \juniper\StructType\WarningType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \juniper\StructType\WarningType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Warning
     */
    public function getAttributeName()
    {
        return 'Warning';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \juniper\ArrayType\ArrayOfWarningType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
