<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for relatedToAllegroType StructType
 * Meta information extracted from the WSDL
 * - documentation: Opcjonalne informacje o powiązaniu przesyłki ze sprzedażą w serwisie Allegro
 * @subpackage Structs
 */
class RelatedToAllegroType extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Id transakcji (MS), deal (WebAPI) lub order (RestAPI)
     * - base: xsd:string
     * - maxLength: 38
     * - minLength: 1
     * @var string
     */
    public $id;
    /**
     * The sellerId
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator sprzedającego w serwisie Allegro.
     * - base: xsd:string
     * - maxLength: 22
     * - minLength: 1
     * @var string
     */
    public $sellerId;
    /**
     * The channel
     * Meta information extracted from the WSDL
     * - documentation: Źródło identyfikatora: MS - Menedżer Sprzedaży Allegro, WEB_API - WebAPI Allegro, REST_API - RestAPI Allegro.
     * @var string
     */
    public $channel;
    /**
     * The deliveryMethod
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator rodzaju dostawy, gdzie dla źródła: MS - nazwa rodzaju dostawy, WEB_API - id postaci liczby, REST_API - id postaci guid
     * - base: xsd:string
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $deliveryMethod;
    /**
     * Constructor method for relatedToAllegroType
     * @uses RelatedToAllegroType::setId()
     * @uses RelatedToAllegroType::setSellerId()
     * @uses RelatedToAllegroType::setChannel()
     * @uses RelatedToAllegroType::setDeliveryMethod()
     * @param string $id
     * @param string $sellerId
     * @param string $channel
     * @param string $deliveryMethod
     */
    public function __construct($id = null, $sellerId = null, $channel = null, $deliveryMethod = null)
    {
        $this
            ->setId($id)
            ->setSellerId($sellerId)
            ->setChannel($channel)
            ->setDeliveryMethod($deliveryMethod);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return RelatedToAllegroType
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get sellerId value
     * @return string|null
     */
    public function getSellerId()
    {
        return $this->sellerId;
    }
    /**
     * Set sellerId value
     * @param string $sellerId
     * @return RelatedToAllegroType
     */
    public function setSellerId($sellerId = null)
    {
        $this->sellerId = $sellerId;
        return $this;
    }
    /**
     * Get channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @param string $channel
     * @return RelatedToAllegroType
     */
    public function setChannel($channel = null)
    {
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get deliveryMethod value
     * @return string|null
     */
    public function getDeliveryMethod()
    {
        return $this->deliveryMethod;
    }
    /**
     * Set deliveryMethod value
     * @param string $deliveryMethod
     * @return RelatedToAllegroType
     */
    public function setDeliveryMethod($deliveryMethod = null)
    {
        $this->deliveryMethod = $deliveryMethod;
        return $this;
    }
}
