<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for przesylkaBiznesowaType StructType
 * @subpackage Structs
 */
class PrzesylkaBiznesowaType extends PrzesylkaRejestrowanaType
{
    /**
     * The subPrzesylka
     * Meta information extracted from the WSDL
     * - choice: urzadWydaniaEPrzesylki | subPrzesylka
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var SubPrzesylkaBiznesowaType[]
     */
    public $subPrzesylka;
    /**
     * The pobranie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PobranieType
     */
    public $pobranie;
    /**
     * The urzadWydaniaEPrzesylki
     * Meta information extracted from the WSDL
     * - choice: urzadWydaniaEPrzesylki | subPrzesylka
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UrzadWydaniaEPrzesylkiType
     */
    public $urzadWydaniaEPrzesylki;
    /**
     * The ubezpieczenie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UbezpieczenieType
     */
    public $ubezpieczenie;
    /**
     * The epo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EPOType
     */
    public $epo;
    /**
     * The adresDlaZwrotu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AdresType
     */
    public $adresDlaZwrotu;
    /**
     * The sprawdzenieZawartosciPrzesylkiPrzezOdbiorce
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce;
    /**
     * The potwierdzenieOdbioru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PotwierdzenieOdbioruBiznesowaType
     */
    public $potwierdzenieOdbioru;
    /**
     * The doreczenie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DoreczenieBiznesowaType
     */
    public $doreczenie;
    /**
     * The zwrotDokumentow
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ZwrotDokumentowBiznesowaType
     */
    public $zwrotDokumentow;
    /**
     * The zasadySpecjalne
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $zasadySpecjalne;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The gabaryt
     * @var string
     */
    public $gabaryt;
    /**
     * The niestandardowa
     * Meta information extracted from the WSDL
     * - documentation: TRUE jeżeli przesyłka niestandardowa. Za przesyłkę niestandardową uważa się przesyłkę spełniającą przynajmniej jedno z poniższych kryteriów: wymiary wynoszące 250 cm < (a+b+c) <= 300 cm, przy czym dł. maks. = 150 cm,
     * wymiary wynoszące (a+b+c) $lte; 250 cm, przy czym dł. maks. = 150 cm, posiadającej: - nieregularne kształty lub - wystające elementy, lub - składającej się z dwóch odrębnych części, połączonych w jedną nieregularną całość (np. za
     * pomocą folii stretch, taśmy itp.).
     * @var bool
     */
    public $niestandardowa;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $wartosc;
    /**
     * The ostroznie
     * @var bool
     */
    public $ostroznie;
    /**
     * The numerPrzesylkiKlienta
     * @var string
     */
    public $numerPrzesylkiKlienta;
    /**
     * The numerTransakcjiOdbioru
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $numerTransakcjiOdbioru;
    /**
     * Constructor method for przesylkaBiznesowaType
     * @uses PrzesylkaBiznesowaType::setSubPrzesylka()
     * @uses PrzesylkaBiznesowaType::setPobranie()
     * @uses PrzesylkaBiznesowaType::setUrzadWydaniaEPrzesylki()
     * @uses PrzesylkaBiznesowaType::setUbezpieczenie()
     * @uses PrzesylkaBiznesowaType::setEpo()
     * @uses PrzesylkaBiznesowaType::setAdresDlaZwrotu()
     * @uses PrzesylkaBiznesowaType::setSprawdzenieZawartosciPrzesylkiPrzezOdbiorce()
     * @uses PrzesylkaBiznesowaType::setPotwierdzenieOdbioru()
     * @uses PrzesylkaBiznesowaType::setDoreczenie()
     * @uses PrzesylkaBiznesowaType::setZwrotDokumentow()
     * @uses PrzesylkaBiznesowaType::setZasadySpecjalne()
     * @uses PrzesylkaBiznesowaType::setMasa()
     * @uses PrzesylkaBiznesowaType::setGabaryt()
     * @uses PrzesylkaBiznesowaType::setNiestandardowa()
     * @uses PrzesylkaBiznesowaType::setWartosc()
     * @uses PrzesylkaBiznesowaType::setOstroznie()
     * @uses PrzesylkaBiznesowaType::setNumerPrzesylkiKlienta()
     * @uses PrzesylkaBiznesowaType::setNumerTransakcjiOdbioru()
     * @param SubPrzesylkaBiznesowaType[] $subPrzesylka
     * @param PobranieType $pobranie
     * @param UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki
     * @param UbezpieczenieType $ubezpieczenie
     * @param EPOType $epo
     * @param AdresType $adresDlaZwrotu
     * @param bool $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce
     * @param PotwierdzenieOdbioruBiznesowaType $potwierdzenieOdbioru
     * @param DoreczenieBiznesowaType $doreczenie
     * @param ZwrotDokumentowBiznesowaType $zwrotDokumentow
     * @param string $zasadySpecjalne
     * @param int $masa
     * @param string $gabaryt
     * @param bool $niestandardowa
     * @param int $wartosc
     * @param bool $ostroznie
     * @param string $numerPrzesylkiKlienta
     * @param string $numerTransakcjiOdbioru
     */
    public function __construct(array $subPrzesylka = array(), PobranieType $pobranie = null, UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki = null, UbezpieczenieType $ubezpieczenie = null, EPOType $epo = null, AdresType $adresDlaZwrotu = null, $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce = null, PotwierdzenieOdbioruBiznesowaType $potwierdzenieOdbioru = null, DoreczenieBiznesowaType $doreczenie = null, ZwrotDokumentowBiznesowaType $zwrotDokumentow = null, $zasadySpecjalne = null, $masa = null, $gabaryt = null, $niestandardowa = null, $wartosc = null, $ostroznie = null, $numerPrzesylkiKlienta = null, $numerTransakcjiOdbioru = null)
    {
        $this
            ->setSubPrzesylka($subPrzesylka)
            ->setPobranie($pobranie)
            ->setUrzadWydaniaEPrzesylki($urzadWydaniaEPrzesylki)
            ->setUbezpieczenie($ubezpieczenie)
            ->setEpo($epo)
            ->setAdresDlaZwrotu($adresDlaZwrotu)
            ->setSprawdzenieZawartosciPrzesylkiPrzezOdbiorce($sprawdzenieZawartosciPrzesylkiPrzezOdbiorce)
            ->setPotwierdzenieOdbioru($potwierdzenieOdbioru)
            ->setDoreczenie($doreczenie)
            ->setZwrotDokumentow($zwrotDokumentow)
            ->setZasadySpecjalne($zasadySpecjalne)
            ->setMasa($masa)
            ->setGabaryt($gabaryt)
            ->setNiestandardowa($niestandardowa)
            ->setWartosc($wartosc)
            ->setOstroznie($ostroznie)
            ->setNumerPrzesylkiKlienta($numerPrzesylkiKlienta)
            ->setNumerTransakcjiOdbioru($numerTransakcjiOdbioru);
    }
    /**
     * Get subPrzesylka value
     * @return SubPrzesylkaBiznesowaType[]
     */
    public function getSubPrzesylka()
    {
        return isset($this->subPrzesylka) ? $this->subPrzesylka : null;
    }
    /**
     * Set subPrzesylka value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param SubPrzesylkaBiznesowaType[] $subPrzesylka
     * @return PrzesylkaBiznesowaType
     */
    public function setSubPrzesylka(array $subPrzesylka = array())
    {
        if (is_null($subPrzesylka) || (is_array($subPrzesylka) && empty($subPrzesylka))) {
            unset($this->subPrzesylka);
        } else {
            $this->subPrzesylka = $subPrzesylka;
        }
        return $this;
    }
    /**
     * Add item to subPrzesylka value
     * @throws \InvalidArgumentException
     * @param SubPrzesylkaBiznesowaType $item
     * @return PrzesylkaBiznesowaType
     */
    public function addToSubPrzesylka(SubPrzesylkaBiznesowaType $item)
    {
        $this->subPrzesylka[] = $item;
        return $this;
    }
    /**
     * Get pobranie value
     * @return PobranieType|null
     */
    public function getPobranie()
    {
        return $this->pobranie;
    }
    /**
     * Set pobranie value
     * @param PobranieType $pobranie
     * @return PrzesylkaBiznesowaType
     */
    public function setPobranie(PobranieType $pobranie = null)
    {
        $this->pobranie = $pobranie;
        return $this;
    }
    /**
     * Get urzadWydaniaEPrzesylki value
     * @return UrzadWydaniaEPrzesylkiType|null
     */
    public function getUrzadWydaniaEPrzesylki()
    {
        return isset($this->urzadWydaniaEPrzesylki) ? $this->urzadWydaniaEPrzesylki : null;
    }
    /**
     * Set urzadWydaniaEPrzesylki value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki
     * @return PrzesylkaBiznesowaType
     */
    public function setUrzadWydaniaEPrzesylki(UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki = null)
    {
        if (is_null($urzadWydaniaEPrzesylki) || (is_array($urzadWydaniaEPrzesylki) && empty($urzadWydaniaEPrzesylki))) {
            unset($this->urzadWydaniaEPrzesylki);
        } else {
            $this->urzadWydaniaEPrzesylki = $urzadWydaniaEPrzesylki;
        }
        return $this;
    }
    /**
     * Get ubezpieczenie value
     * @return UbezpieczenieType|null
     */
    public function getUbezpieczenie()
    {
        return $this->ubezpieczenie;
    }
    /**
     * Set ubezpieczenie value
     * @param UbezpieczenieType $ubezpieczenie
     * @return PrzesylkaBiznesowaType
     */
    public function setUbezpieczenie(UbezpieczenieType $ubezpieczenie = null)
    {
        $this->ubezpieczenie = $ubezpieczenie;
        return $this;
    }
    /**
     * Get epo value
     * @return EPOType|null
     */
    public function getEpo()
    {
        return $this->epo;
    }
    /**
     * Set epo value
     * @param EPOType $epo
     * @return PrzesylkaBiznesowaType
     */
    public function setEpo(EPOType $epo = null)
    {
        $this->epo = $epo;
        return $this;
    }
    /**
     * Get adresDlaZwrotu value
     * @return AdresType|null
     */
    public function getAdresDlaZwrotu()
    {
        return $this->adresDlaZwrotu;
    }
    /**
     * Set adresDlaZwrotu value
     * @param AdresType $adresDlaZwrotu
     * @return PrzesylkaBiznesowaType
     */
    public function setAdresDlaZwrotu(AdresType $adresDlaZwrotu = null)
    {
        $this->adresDlaZwrotu = $adresDlaZwrotu;
        return $this;
    }
    /**
     * Get sprawdzenieZawartosciPrzesylkiPrzezOdbiorce value
     * @return bool|null
     */
    public function getSprawdzenieZawartosciPrzesylkiPrzezOdbiorce()
    {
        return $this->sprawdzenieZawartosciPrzesylkiPrzezOdbiorce;
    }
    /**
     * Set sprawdzenieZawartosciPrzesylkiPrzezOdbiorce value
     * @param bool $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce
     * @return PrzesylkaBiznesowaType
     */
    public function setSprawdzenieZawartosciPrzesylkiPrzezOdbiorce($sprawdzenieZawartosciPrzesylkiPrzezOdbiorce = null)
    {
        $this->sprawdzenieZawartosciPrzesylkiPrzezOdbiorce = $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce;
        return $this;
    }
    /**
     * Get potwierdzenieOdbioru value
     * @return PotwierdzenieOdbioruBiznesowaType|null
     */
    public function getPotwierdzenieOdbioru()
    {
        return $this->potwierdzenieOdbioru;
    }
    /**
     * Set potwierdzenieOdbioru value
     * @param PotwierdzenieOdbioruBiznesowaType $potwierdzenieOdbioru
     * @return PrzesylkaBiznesowaType
     */
    public function setPotwierdzenieOdbioru(PotwierdzenieOdbioruBiznesowaType $potwierdzenieOdbioru = null)
    {
        $this->potwierdzenieOdbioru = $potwierdzenieOdbioru;
        return $this;
    }
    /**
     * Get doreczenie value
     * @return DoreczenieBiznesowaType|null
     */
    public function getDoreczenie()
    {
        return $this->doreczenie;
    }
    /**
     * Set doreczenie value
     * @param DoreczenieBiznesowaType $doreczenie
     * @return PrzesylkaBiznesowaType
     */
    public function setDoreczenie(DoreczenieBiznesowaType $doreczenie = null)
    {
        $this->doreczenie = $doreczenie;
        return $this;
    }
    /**
     * Get zwrotDokumentow value
     * @return ZwrotDokumentowBiznesowaType|null
     */
    public function getZwrotDokumentow()
    {
        return $this->zwrotDokumentow;
    }
    /**
     * Set zwrotDokumentow value
     * @param ZwrotDokumentowBiznesowaType $zwrotDokumentow
     * @return PrzesylkaBiznesowaType
     */
    public function setZwrotDokumentow(ZwrotDokumentowBiznesowaType $zwrotDokumentow = null)
    {
        $this->zwrotDokumentow = $zwrotDokumentow;
        return $this;
    }
    /**
     * Get zasadySpecjalne value
     * @return string|null
     */
    public function getZasadySpecjalne()
    {
        return $this->zasadySpecjalne;
    }
    /**
     * Set zasadySpecjalne value
     * @param string $zasadySpecjalne
     * @return PrzesylkaBiznesowaType
     */
    public function setZasadySpecjalne($zasadySpecjalne = null)
    {
        $this->zasadySpecjalne = $zasadySpecjalne;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return PrzesylkaBiznesowaType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get gabaryt value
     * @return string|null
     */
    public function getGabaryt()
    {
        return $this->gabaryt;
    }
    /**
     * Set gabaryt value
     * @param string $gabaryt
     * @return PrzesylkaBiznesowaType
     */
    public function setGabaryt($gabaryt = null)
    {
        $this->gabaryt = $gabaryt;
        return $this;
    }
    /**
     * Get niestandardowa value
     * @return bool|null
     */
    public function getNiestandardowa()
    {
        return $this->niestandardowa;
    }
    /**
     * Set niestandardowa value
     * @param bool $niestandardowa
     * @return PrzesylkaBiznesowaType
     */
    public function setNiestandardowa($niestandardowa = null)
    {
        $this->niestandardowa = $niestandardowa;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return PrzesylkaBiznesowaType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get ostroznie value
     * @return bool|null
     */
    public function getOstroznie()
    {
        return $this->ostroznie;
    }
    /**
     * Set ostroznie value
     * @param bool $ostroznie
     * @return PrzesylkaBiznesowaType
     */
    public function setOstroznie($ostroznie = null)
    {
        $this->ostroznie = $ostroznie;
        return $this;
    }
    /**
     * Get numerPrzesylkiKlienta value
     * @return string|null
     */
    public function getNumerPrzesylkiKlienta()
    {
        return $this->numerPrzesylkiKlienta;
    }
    /**
     * Set numerPrzesylkiKlienta value
     * @param string $numerPrzesylkiKlienta
     * @return PrzesylkaBiznesowaType
     */
    public function setNumerPrzesylkiKlienta($numerPrzesylkiKlienta = null)
    {
        $this->numerPrzesylkiKlienta = $numerPrzesylkiKlienta;
        return $this;
    }
    /**
     * Get numerTransakcjiOdbioru value
     * @return string|null
     */
    public function getNumerTransakcjiOdbioru()
    {
        return $this->numerTransakcjiOdbioru;
    }
    /**
     * Set numerTransakcjiOdbioru value
     * @param string $numerTransakcjiOdbioru
     * @return PrzesylkaBiznesowaType
     */
    public function setNumerTransakcjiOdbioru($numerTransakcjiOdbioru = null)
    {
        $this->numerTransakcjiOdbioru = $numerTransakcjiOdbioru;
        return $this;
    }
}
