<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for przesylkaShortType StructType
 * @subpackage Structs
 */
class PrzesylkaShortType extends AbstractStructBase
{
    /**
     * The guid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 32
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $guid;
    /**
     * The czynnosciUpustowe
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $czynnosciUpustowe;
    /**
     * The numerNadania
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 10
     * @var string
     */
    public $numerNadania;
    /**
     * The dataNadania
     * @var string
     */
    public $dataNadania;
    /**
     * The razem
     * @var int
     */
    public $razem;
    /**
     * The pobranie
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $pobranie;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * Constructor method for przesylkaShortType
     * @uses PrzesylkaShortType::setGuid()
     * @uses PrzesylkaShortType::setCzynnosciUpustowe()
     * @uses PrzesylkaShortType::setNumerNadania()
     * @uses PrzesylkaShortType::setDataNadania()
     * @uses PrzesylkaShortType::setRazem()
     * @uses PrzesylkaShortType::setPobranie()
     * @uses PrzesylkaShortType::setStatus()
     * @param string $guid
     * @param string[] $czynnosciUpustowe
     * @param string $numerNadania
     * @param string $dataNadania
     * @param int $razem
     * @param int $pobranie
     * @param string $status
     */
    public function __construct($guid = null, array $czynnosciUpustowe = array(), $numerNadania = null, $dataNadania = null, $razem = null, $pobranie = null, $status = null)
    {
        $this
            ->setGuid($guid)
            ->setCzynnosciUpustowe($czynnosciUpustowe)
            ->setNumerNadania($numerNadania)
            ->setDataNadania($dataNadania)
            ->setRazem($razem)
            ->setPobranie($pobranie)
            ->setStatus($status);
    }
    /**
     * Get guid value
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return PrzesylkaShortType
     */
    public function setGuid($guid = null)
    {
        $this->guid = $guid;
        return $this;
    }
    /**
     * Get czynnosciUpustowe value
     * @return string[]|null
     */
    public function getCzynnosciUpustowe()
    {
        return $this->czynnosciUpustowe;
    }
    /**
     * Set czynnosciUpustowe value
     * @param string[] $czynnosciUpustowe
     * @return PrzesylkaShortType
     */
    public function setCzynnosciUpustowe(array $czynnosciUpustowe = array())
    {
        $this->czynnosciUpustowe = $czynnosciUpustowe;
        return $this;
    }
    /**
     * Add item to czynnosciUpustowe value
     * @uses CzynnoscUpustowaType::valueIsValid()
     * @uses CzynnoscUpustowaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return PrzesylkaShortType
     */
    public function addToCzynnosciUpustowe($item)
    {
        $this->czynnosciUpustowe[] = $item;
        return $this;
    }
    /**
     * Get numerNadania value
     * @return string|null
     */
    public function getNumerNadania()
    {
        return $this->numerNadania;
    }
    /**
     * Set numerNadania value
     * @param string $numerNadania
     * @return PrzesylkaShortType
     */
    public function setNumerNadania($numerNadania = null)
    {
        $this->numerNadania = $numerNadania;
        return $this;
    }
    /**
     * Get dataNadania value
     * @return string|null
     */
    public function getDataNadania()
    {
        return $this->dataNadania;
    }
    /**
     * Set dataNadania value
     * @param string $dataNadania
     * @return PrzesylkaShortType
     */
    public function setDataNadania($dataNadania = null)
    {
        $this->dataNadania = $dataNadania;
        return $this;
    }
    /**
     * Get razem value
     * @return int|null
     */
    public function getRazem()
    {
        return $this->razem;
    }
    /**
     * Set razem value
     * @param int $razem
     * @return PrzesylkaShortType
     */
    public function setRazem($razem = null)
    {
        $this->razem = $razem;
        return $this;
    }
    /**
     * Get pobranie value
     * @return int|null
     */
    public function getPobranie()
    {
        return $this->pobranie;
    }
    /**
     * Set pobranie value
     * @param int $pobranie
     * @return PrzesylkaShortType
     */
    public function setPobranie($pobranie = null)
    {
        $this->pobranie = $pobranie;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return PrzesylkaShortType
     */
    public function setStatus($status = null)
    {
        $this->status = $status;
        return $this;
    }
}
