<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddShipment $parameters
     * @return AddShipmentResponse|bool
     */
    public function addShipment(AddShipment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addShipment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named changePassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ChangePassword $parameters
     * @return ChangePasswordResponse|bool
     */
    public function changePassword(ChangePassword $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->changePassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendEnvelope
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendEnvelope $parameters
     * @return SendEnvelopeResponseType|bool
     */
    public function sendEnvelope(SendEnvelope $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendEnvelope($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUrzedyNadania
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetUrzedyNadania $parameters
     * @return GetUrzedyNadaniaResponse|bool
     */
    public function getUrzedyNadania(GetUrzedyNadania $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getUrzedyNadania($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named clearEnvelope
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ClearEnvelope $parameters
     * @return ClearEnvelopeResponse|bool
     */
    public function clearEnvelope(ClearEnvelope $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->clearEnvelope($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named uploadIWDContent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UploadIWDContent $parameters
     * @return SendEnvelopeResponseType|bool
     */
    public function uploadIWDContent(UploadIWDContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->uploadIWDContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnvelopeStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEnvelopeStatus $parameters
     * @return GetEnvelopeStatusResponse|bool
     */
    public function getEnvelopeStatus(GetEnvelopeStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnvelopeStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named downloadIWDContent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param DownloadIWDContent $parameters
     * @return DownloadIWDContentResponse|bool
     */
    public function downloadIWDContent(DownloadIWDContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->downloadIWDContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKarty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetKarty $parameters
     * @return GetKartyResponse|bool
     */
    public function getKarty(GetKarty $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKarty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPasswordExpiredDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetPasswordExpiredDate $parameters
     * @return GetPasswordExpiredDateResponse|bool
     */
    public function getPasswordExpiredDate(GetPasswordExpiredDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPasswordExpiredDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setAktywnaKarta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SetAktywnaKarta $parameters
     * @return SetAktywnaKartaResponse|bool
     */
    public function setAktywnaKarta(SetAktywnaKarta $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setAktywnaKarta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hello
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param Hello $parameters
     * @return HelloResponse|bool
     */
    public function hello(Hello $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->hello($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnvelopeContentShort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEnvelopeContentShort $parameters
     * @return GetEnvelopeContentShortResponse|bool
     */
    public function getEnvelopeContentShort(GetEnvelopeContentShort $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnvelopeContentShort($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnvelopeContentFull
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEnvelopeContentFull $parameters
     * @return GetEnvelopeContentFullResponse|bool
     */
    public function getEnvelopeContentFull(GetEnvelopeContentFull $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnvelopeContentFull($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAddressLabel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetAddressLabel $parameters
     * @return GetAddressLabelResponse|bool
     */
    public function getAddressLabel(GetAddressLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAddressLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOutboxBook
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetOutboxBook $parameters
     * @return GetOutboxBookResponse|bool
     */
    public function getOutboxBook(GetOutboxBook $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getOutboxBook($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFirmowaPocztaBook
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetFirmowaPocztaBook $parameters
     * @return GetFirmowaPocztaBookResponse|bool
     */
    public function getFirmowaPocztaBook(GetFirmowaPocztaBook $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getFirmowaPocztaBook($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnvelopeList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEnvelopeList $parameters
     * @return GetEnvelopeListResponse|bool
     */
    public function getEnvelopeList(GetEnvelopeList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnvelopeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAddresLabelByGuid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetAddresLabelByGuid $parameters
     * @return GetAddresLabelByGuidResponse|bool
     */
    public function getAddresLabelByGuid(GetAddresLabelByGuid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAddresLabelByGuid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPlacowkiPocztowe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetPlacowkiPocztowe $parameters
     * @return GetPlacowkiPocztoweResponse|bool
     */
    public function getPlacowkiPocztowe(GetPlacowkiPocztowe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPlacowkiPocztowe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGuid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetGuid $parameters
     * @return GetGuidResponse|bool
     */
    public function getGuid(GetGuid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getGuid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKierunki
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetKierunki $parameters
     * @return GetKierunkiResponse|bool
     */
    public function getKierunki(GetKierunki $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKierunki($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKierunkiInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetKierunkiInfo $parameters
     * @return GetKierunkiInfoResponse|bool
     */
    public function getKierunkiInfo(GetKierunkiInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKierunkiInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnvelopeBufor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEnvelopeBufor $parameters
     * @return GetEnvelopeBuforResponse|bool
     */
    public function getEnvelopeBufor(GetEnvelopeBufor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnvelopeBufor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named clearEnvelopeByGuids
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ClearEnvelopeByGuids $parameters
     * @return ClearEnvelopeByGuidsResponse|bool
     */
    public function clearEnvelopeByGuids(ClearEnvelopeByGuids $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->clearEnvelopeByGuids($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEPOStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEPOStatus $parameters
     * @return GetEPOStatusResponse|bool
     */
    public function getEPOStatus(GetEPOStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEPOStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAddresLabelCompact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetAddresLabelCompact $parameters
     * @return GetAddresLabelCompactResponse|bool
     */
    public function getAddresLabelCompact(GetAddresLabelCompact $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAddresLabelCompact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAddresLabelByGuidCompact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetAddresLabelByGuidCompact $parameters
     * @return GetAddresLabelByGuidCompactResponse|bool
     */
    public function getAddresLabelByGuidCompact(GetAddresLabelByGuidCompact $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAddresLabelByGuidCompact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnvelopeBuforList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEnvelopeBuforList $parameters
     * @return GetEnvelopeBuforListResponse|bool
     */
    public function getEnvelopeBuforList(GetEnvelopeBuforList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnvelopeBuforList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createEnvelopeBufor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateEnvelopeBufor $parameters
     * @return CreateEnvelopeBuforResponse|bool
     */
    public function createEnvelopeBufor(CreateEnvelopeBufor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createEnvelopeBufor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateEnvelopeBufor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateEnvelopeBufor $parameters
     * @return UpdateEnvelopeBuforResponse|bool
     */
    public function updateEnvelopeBufor(UpdateEnvelopeBufor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateEnvelopeBufor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveShipments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param MoveShipments $parameters
     * @return MoveShipmentsResponse|bool
     */
    public function moveShipments(MoveShipments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->moveShipments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUbezpieczeniaInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetUbezpieczeniaInfo $parameters
     * @return GetUbezpieczeniaInfoResponse|bool
     */
    public function getUbezpieczeniaInfo(GetUbezpieczeniaInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getUbezpieczeniaInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named isMiejscowa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param IsMiejscowa $parameters
     * @return IsMiejscowaResponse|bool
     */
    public function isMiejscowa(IsMiejscowa $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->isMiejscowa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBlankietPobraniaByGuids
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetBlankietPobraniaByGuids $parameters
     * @return GetBlankietPobraniaByGuidsResponse|bool
     */
    public function getBlankietPobraniaByGuids(GetBlankietPobraniaByGuids $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBlankietPobraniaByGuids($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateAccount $parameters
     * @return UpdateAccountResponse|bool
     */
    public function updateAccount(UpdateAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccountList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetAccountList $parameters
     * @return GetAccountListResponse|bool
     */
    public function getAccountList(GetAccountList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAccountList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProfilList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetProfilList $parameters
     * @return GetProfilListResponse|bool
     */
    public function getProfilList(GetProfilList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getProfilList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateProfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateProfil $parameters
     * @return UpdateProfilResponse|bool
     */
    public function updateProfil(UpdateProfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateProfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateAccount $parameters
     * @return CreateAccountResponse|bool
     */
    public function createAccount(CreateAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createProfil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateProfil $parameters
     * @return CreateProfilResponse|bool
     */
    public function createProfil(CreateProfil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createProfil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addReklamacje
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddReklamacje $parameters
     * @return AddReklamacjeResponse|bool
     */
    public function addReklamacje(AddReklamacje $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addReklamacje($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReklamacje
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetReklamacje $parameters
     * @return GetReklamacjeResponse|bool
     */
    public function getReklamacje(GetReklamacje $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getReklamacje($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addOdwolanieDoReklamacji
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddOdwolanieDoReklamacji $parameters
     * @return AddOdwolanieDoReklamacjiResponse|bool
     */
    public function addOdwolanieDoReklamacji(AddOdwolanieDoReklamacji $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addOdwolanieDoReklamacji($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named cancelReklamacja
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CancelReklamacja $parameters
     * @return CancelReklamacjaResponse|bool
     */
    public function cancelReklamacja(CancelReklamacja $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->cancelReklamacja($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getZapowiedziFaktur
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetZapowiedziFaktur $parameters
     * @return GetZapowiedziFakturResponse|bool
     */
    public function getZapowiedziFaktur(GetZapowiedziFaktur $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getZapowiedziFaktur($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRozbieznoscDoZapowiedziFaktur
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddRozbieznoscDoZapowiedziFaktur $parameters
     * @return AddRozbieznoscDoZapowiedziFakturResponse|bool
     */
    public function addRozbieznoscDoZapowiedziFaktur(AddRozbieznoscDoZapowiedziFaktur $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addRozbieznoscDoZapowiedziFaktur($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getListaPowodowReklamacji
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetListaPowodowReklamacji $parameters
     * @return GetListaPowodowReklamacjiResponse|bool
     */
    public function getListaPowodowReklamacji(GetListaPowodowReklamacji $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getListaPowodowReklamacji($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named zamowKuriera
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ZamowKuriera $parameters
     * @return ZamowKurieraResponse|bool
     */
    public function zamowKuriera(ZamowKuriera $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->zamowKuriera($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEZDO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEZDO $parameters
     * @return GetEZDOResponse|bool
     */
    public function getEZDO(GetEZDO $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEZDO($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEZDOList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEZDOList $parameters
     * @return GetEZDOListResponse|bool
     */
    public function getEZDOList(GetEZDOList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEZDOList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWplatyCKP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetWplatyCKP $parameters
     * @return GetWplatyCKPResponse|bool
     */
    public function getWplatyCKP(GetWplatyCKP $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getWplatyCKP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addZalacznikDoReklamacji
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddZalacznikDoReklamacji $parameters
     * @return AddZalacznikDoReklamacjiResponse|bool
     */
    public function addZalacznikDoReklamacji(AddZalacznikDoReklamacji $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addZalacznikDoReklamacji($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateShopEZwroty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateShopEZwroty $parameters
     * @return UpdateShopEZwrotyResponse|bool
     */
    public function updateShopEZwroty(UpdateShopEZwroty $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateShopEZwroty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getListaZgodEZwrotow
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetListaZgodEZwrotow $parameters
     * @return GetListaZgodEZwrotowResponse|bool
     */
    public function getListaZgodEZwrotow(GetListaZgodEZwrotow $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getListaZgodEZwrotow($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setStatusZgodyNaEZwrot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SetStatusZgodyNaEZwrot $parameters
     * @return SetStatusZgodyNaEZwrotResponse|bool
     */
    public function setStatusZgodyNaEZwrot(SetStatusZgodyNaEZwrot $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setStatusZgodyNaEZwrot($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named wyslijLinkaOStatusieEZwrotu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param WyslijLinkaOStatusieEZwrotu $parameters
     * @return WyslijLinkaOStatusieEZwrotuResponse|bool
     */
    public function wyslijLinkaOStatusieEZwrotu(WyslijLinkaOStatusieEZwrotu $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->wyslijLinkaOStatusieEZwrotu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named isObszarMiasto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param IsObszarMiasto $parameters
     * @return IsObszarMiastoResponse|bool
     */
    public function isObszarMiasto(IsObszarMiasto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->isObszarMiasto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setJednostkaOrganizacyjna
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SetJednostkaOrganizacyjna $parameters
     * @return SetJednostkaOrganizacyjnaResponse|bool
     */
    public function setJednostkaOrganizacyjna(SetJednostkaOrganizacyjna $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setJednostkaOrganizacyjna($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getJednostkaOrganizacyjna
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetJednostkaOrganizacyjna $parameters
     * @return GetJednostkaOrganizacyjnaResponse|bool
     */
    public function getJednostkaOrganizacyjna(GetJednostkaOrganizacyjna $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getJednostkaOrganizacyjna($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createReturnDocumentsProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateReturnDocumentsProfile $parameters
     * @return CreateReturnDocumentsProfileResponse|bool
     */
    public function createReturnDocumentsProfile(CreateReturnDocumentsProfile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createReturnDocumentsProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateReturnDocumentsProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateReturnDocumentsProfile $parameters
     * @return UpdateReturnDocumentsProfileResponse|bool
     */
    public function updateReturnDocumentsProfile(UpdateReturnDocumentsProfile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateReturnDocumentsProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteReturnDocumentsProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param DeleteReturnDocumentsProfile $parameters
     * @return DeleteReturnDocumentsProfileResponse|bool
     */
    public function deleteReturnDocumentsProfile(DeleteReturnDocumentsProfile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteReturnDocumentsProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReturnDocumentsProfileList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetReturnDocumentsProfileList $parameters
     * @return GetReturnDocumentsProfileListResponse|bool
     */
    public function getReturnDocumentsProfileList(GetReturnDocumentsProfileList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getReturnDocumentsProfileList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAdditionalActivitiesList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetAdditionalActivitiesList $parameters
     * @return GetAdditionalActivitiesListResponse|bool
     */
    public function getAdditionalActivitiesList(GetAdditionalActivitiesList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAdditionalActivitiesList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getChecklistTemplateList
     * Meta information extracted from the WSDL
     * - documentation: Metoda zwraca kolekcję szablonów list czynności. Jeżeli nie przekazano elementów idChecklistTemplate metoda zwróci wyłącznie kolekcję opisów szablonów list czynności. Jeżeli przekazano elementy idChecklistTemplate metoda
     * zwróci pełny opis szablonu listy czynności.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetChecklistTemplateList $parameters
     * @return GetChecklistTemplateListResponse|bool
     */
    public function getChecklistTemplateList(GetChecklistTemplateList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getChecklistTemplateList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getParcelContentList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetParcelContentList $parameters
     * @return GetParcelContentListResponse|bool
     */
    public function getParcelContentList(GetParcelContentList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getParcelContentList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createParcelContent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateParcelContent $parameters
     * @return CreateParcelContentResponse|bool
     */
    public function createParcelContent(CreateParcelContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createParcelContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateParcelContent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateParcelContent $parameters
     * @return UpdateParcelContentResponse|bool
     */
    public function updateParcelContent(UpdateParcelContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateParcelContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteParcelContent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param DeleteParcelContent $parameters
     * @return DeleteParcelContentResponse|bool
     */
    public function deleteParcelContent(DeleteParcelContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteParcelContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createChecklistTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateChecklistTemplate $parameters
     * @return CreateChecklistTemplateResponse|bool
     */
    public function createChecklistTemplate(CreateChecklistTemplate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createChecklistTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateChecklistTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateChecklistTemplate $parameters
     * @return UpdateChecklistTemplateResponse|bool
     */
    public function updateChecklistTemplate(UpdateChecklistTemplate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateChecklistTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteChecklistTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param DeleteChecklistTemplate $parameters
     * @return DeleteChecklistTemplateResponse|bool
     */
    public function deleteChecklistTemplate(DeleteChecklistTemplate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteChecklistTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createShopEZwroty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateShopEZwroty $parameters
     * @return CreateShopEZwrotyResponse|bool
     */
    public function createShopEZwroty(CreateShopEZwroty $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createShopEZwroty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteShopEZwroty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param DeleteShopEZwroty $parameters
     * @return DeleteShopEZwrotyResponse|bool
     */
    public function deleteShopEZwroty(DeleteShopEZwroty $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteShopEZwroty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getShopEZwrotyList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetShopEZwrotyList $parameters
     * @return GetShopEZwrotyListResponse|bool
     */
    public function getShopEZwrotyList(GetShopEZwrotyList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getShopEZwrotyList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPrintForParcel
     * Meta information extracted from the WSDL
     * - documentation: The method returns parcels printouts for passed guid's
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetPrintForParcel $parameters
     * @return GetPrintForParcelResponse|bool
     */
    public function getPrintForParcel(GetPrintForParcel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPrintForParcel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLibrariesForLegalDeposits
     * Meta information extracted from the WSDL
     * - documentation: The method returns a list of libraries for legal deposit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetLibrariesForLegalDeposits $parameters
     * @return GetLibrariesForLegalDepositsResponse|bool
     */
    public function getLibrariesForLegalDeposits(GetLibrariesForLegalDeposits $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLibrariesForLegalDeposits($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named orderEasyReturnSolutionLabel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param OrderEasyReturnSolutionLabel $parameters
     * @return OrderEasyReturnSolutionLabelResponse|bool
     */
    public function orderEasyReturnSolutionLabel(OrderEasyReturnSolutionLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->orderEasyReturnSolutionLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPlacowkaPocztowa
     * Meta information extracted from the WSDL
     * - documentation: Metoda zwraca dane placówki pocztowej na podstawie jej identyfikatora (PNI)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetPlacowkaPocztowa $parameters
     * @return GetPlacowkaPocztowaResponse|bool
     */
    public function getPlacowkaPocztowa(GetPlacowkaPocztowa $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPlacowkaPocztowa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return AddOdwolanieDoReklamacjiResponse|AddReklamacjeResponse|AddRozbieznoscDoZapowiedziFakturResponse|AddShipmentResponse|AddZalacznikDoReklamacjiResponse|CancelReklamacjaResponse|ChangePasswordResponse|ClearEnvelopeByGuidsResponse|ClearEnvelopeResponse|CreateAccountResponse|CreateChecklistTemplateResponse|CreateEnvelopeBuforResponse|CreateParcelContentResponse|CreateProfilResponse|CreateReturnDocumentsProfileResponse|CreateShopEZwrotyResponse|DeleteChecklistTemplateResponse|DeleteParcelContentResponse|DeleteReturnDocumentsProfileResponse|DeleteShopEZwrotyResponse|DownloadIWDContentResponse|GetAccountListResponse|GetAdditionalActivitiesListResponse|GetAddresLabelByGuidCompactResponse|GetAddresLabelByGuidResponse|GetAddresLabelCompactResponse|GetAddressLabelResponse|GetBlankietPobraniaByGuidsResponse|GetChecklistTemplateListResponse|GetEnvelopeBuforListResponse|GetEnvelopeBuforResponse|GetEnvelopeContentFullResponse|GetEnvelopeContentShortResponse|GetEnvelopeListResponse|GetEnvelopeStatusResponse|GetEPOStatusResponse|GetEZDOListResponse|GetEZDOResponse|GetFirmowaPocztaBookResponse|GetGuidResponse|GetJednostkaOrganizacyjnaResponse|GetKartyResponse|GetKierunkiInfoResponse|GetKierunkiResponse|GetLibrariesForLegalDepositsResponse|GetListaPowodowReklamacjiResponse|GetListaZgodEZwrotowResponse|GetOutboxBookResponse|GetParcelContentListResponse|GetPasswordExpiredDateResponse|GetPlacowkaPocztowaResponse|GetPlacowkiPocztoweResponse|GetPrintForParcelResponse|GetProfilListResponse|GetReklamacjeResponse|GetReturnDocumentsProfileListResponse|GetShopEZwrotyListResponse|GetUbezpieczeniaInfoResponse|GetUrzedyNadaniaResponse|GetWplatyCKPResponse|GetZapowiedziFakturResponse|HelloResponse|IsMiejscowaResponse|IsObszarMiastoResponse|MoveShipmentsResponse|OrderEasyReturnSolutionLabelResponse|SendEnvelopeResponseType|SetAktywnaKartaResponse|SetJednostkaOrganizacyjnaResponse|SetStatusZgodyNaEZwrotResponse|UpdateAccountResponse|UpdateChecklistTemplateResponse|UpdateEnvelopeBuforResponse|UpdateParcelContentResponse|UpdateProfilResponse|UpdateReturnDocumentsProfileResponse|UpdateShopEZwrotyResponse|WyslijLinkaOStatusieEZwrotuResponse|ZamowKurieraResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
