<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for przesylkaProceduralnaType StructType
 * @subpackage Structs
 */
class PrzesylkaProceduralnaType extends PrzesylkaRejestrowanaType
{
    /**
     * The ubezpieczenie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UbezpieczenieType
     */
    public $ubezpieczenie;
    /**
     * The epo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EPOType
     */
    public $epo;
    /**
     * The urzadWydaniaEPrzesylki
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UrzadWydaniaEPrzesylkiType
     */
    public $urzadWydaniaEPrzesylki;
    /**
     * The pobranie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PobranieType
     */
    public $pobranie;
    /**
     * The serwis
     * @var string
     */
    public $serwis;
    /**
     * The numerNadaniaPowrot1
     * @var string
     */
    public $numerNadaniaPowrot1;
    /**
     * The numerNadaniaPowrot2
     * @var string
     */
    public $numerNadaniaPowrot2;
    /**
     * The idPrzesylkaZawartosc
     * @var int
     */
    public $idPrzesylkaZawartosc;
    /**
     * The idListaCzynnosci
     * @var int
     */
    public $idListaCzynnosci;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The opakowanie
     * @var string
     */
    public $opakowanie;
    /**
     * The numerPrzesylkiKlienta
     * @var string
     */
    public $numerPrzesylkiKlienta;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $wartosc;
    /**
     * The idAdresPrzesylkaPowrot
     * @var int
     */
    public $idAdresPrzesylkaPowrot;
    /**
     * Constructor method for przesylkaProceduralnaType
     * @uses PrzesylkaProceduralnaType::setUbezpieczenie()
     * @uses PrzesylkaProceduralnaType::setEpo()
     * @uses PrzesylkaProceduralnaType::setUrzadWydaniaEPrzesylki()
     * @uses PrzesylkaProceduralnaType::setPobranie()
     * @uses PrzesylkaProceduralnaType::setSerwis()
     * @uses PrzesylkaProceduralnaType::setNumerNadaniaPowrot1()
     * @uses PrzesylkaProceduralnaType::setNumerNadaniaPowrot2()
     * @uses PrzesylkaProceduralnaType::setIdPrzesylkaZawartosc()
     * @uses PrzesylkaProceduralnaType::setIdListaCzynnosci()
     * @uses PrzesylkaProceduralnaType::setMasa()
     * @uses PrzesylkaProceduralnaType::setOpakowanie()
     * @uses PrzesylkaProceduralnaType::setNumerPrzesylkiKlienta()
     * @uses PrzesylkaProceduralnaType::setWartosc()
     * @uses PrzesylkaProceduralnaType::setIdAdresPrzesylkaPowrot()
     * @param UbezpieczenieType $ubezpieczenie
     * @param EPOType $epo
     * @param UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki
     * @param PobranieType $pobranie
     * @param string $serwis
     * @param string $numerNadaniaPowrot1
     * @param string $numerNadaniaPowrot2
     * @param int $idPrzesylkaZawartosc
     * @param int $idListaCzynnosci
     * @param int $masa
     * @param string $opakowanie
     * @param string $numerPrzesylkiKlienta
     * @param int $wartosc
     * @param int $idAdresPrzesylkaPowrot
     */
    public function __construct(UbezpieczenieType $ubezpieczenie = null, EPOType $epo = null, UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki = null, PobranieType $pobranie = null, $serwis = null, $numerNadaniaPowrot1 = null, $numerNadaniaPowrot2 = null, $idPrzesylkaZawartosc = null, $idListaCzynnosci = null, $masa = null, $opakowanie = null, $numerPrzesylkiKlienta = null, $wartosc = null, $idAdresPrzesylkaPowrot = null)
    {
        $this
            ->setUbezpieczenie($ubezpieczenie)
            ->setEpo($epo)
            ->setUrzadWydaniaEPrzesylki($urzadWydaniaEPrzesylki)
            ->setPobranie($pobranie)
            ->setSerwis($serwis)
            ->setNumerNadaniaPowrot1($numerNadaniaPowrot1)
            ->setNumerNadaniaPowrot2($numerNadaniaPowrot2)
            ->setIdPrzesylkaZawartosc($idPrzesylkaZawartosc)
            ->setIdListaCzynnosci($idListaCzynnosci)
            ->setMasa($masa)
            ->setOpakowanie($opakowanie)
            ->setNumerPrzesylkiKlienta($numerPrzesylkiKlienta)
            ->setWartosc($wartosc)
            ->setIdAdresPrzesylkaPowrot($idAdresPrzesylkaPowrot);
    }
    /**
     * Get ubezpieczenie value
     * @return UbezpieczenieType|null
     */
    public function getUbezpieczenie()
    {
        return $this->ubezpieczenie;
    }
    /**
     * Set ubezpieczenie value
     * @param UbezpieczenieType $ubezpieczenie
     * @return PrzesylkaProceduralnaType
     */
    public function setUbezpieczenie(UbezpieczenieType $ubezpieczenie = null)
    {
        $this->ubezpieczenie = $ubezpieczenie;
        return $this;
    }
    /**
     * Get epo value
     * @return EPOType|null
     */
    public function getEpo()
    {
        return $this->epo;
    }
    /**
     * Set epo value
     * @param EPOType $epo
     * @return PrzesylkaProceduralnaType
     */
    public function setEpo(EPOType $epo = null)
    {
        $this->epo = $epo;
        return $this;
    }
    /**
     * Get urzadWydaniaEPrzesylki value
     * @return UrzadWydaniaEPrzesylkiType|null
     */
    public function getUrzadWydaniaEPrzesylki()
    {
        return $this->urzadWydaniaEPrzesylki;
    }
    /**
     * Set urzadWydaniaEPrzesylki value
     * @param UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki
     * @return PrzesylkaProceduralnaType
     */
    public function setUrzadWydaniaEPrzesylki(UrzadWydaniaEPrzesylkiType $urzadWydaniaEPrzesylki = null)
    {
        $this->urzadWydaniaEPrzesylki = $urzadWydaniaEPrzesylki;
        return $this;
    }
    /**
     * Get pobranie value
     * @return PobranieType|null
     */
    public function getPobranie()
    {
        return $this->pobranie;
    }
    /**
     * Set pobranie value
     * @param PobranieType $pobranie
     * @return PrzesylkaProceduralnaType
     */
    public function setPobranie(PobranieType $pobranie = null)
    {
        $this->pobranie = $pobranie;
        return $this;
    }
    /**
     * Get serwis value
     * @return string|null
     */
    public function getSerwis()
    {
        return $this->serwis;
    }
    /**
     * Set serwis value
     * @param string $serwis
     * @return PrzesylkaProceduralnaType
     */
    public function setSerwis($serwis = null)
    {
        $this->serwis = $serwis;
        return $this;
    }
    /**
     * Get numerNadaniaPowrot1 value
     * @return string|null
     */
    public function getNumerNadaniaPowrot1()
    {
        return $this->numerNadaniaPowrot1;
    }
    /**
     * Set numerNadaniaPowrot1 value
     * @param string $numerNadaniaPowrot1
     * @return PrzesylkaProceduralnaType
     */
    public function setNumerNadaniaPowrot1($numerNadaniaPowrot1 = null)
    {
        $this->numerNadaniaPowrot1 = $numerNadaniaPowrot1;
        return $this;
    }
    /**
     * Get numerNadaniaPowrot2 value
     * @return string|null
     */
    public function getNumerNadaniaPowrot2()
    {
        return $this->numerNadaniaPowrot2;
    }
    /**
     * Set numerNadaniaPowrot2 value
     * @param string $numerNadaniaPowrot2
     * @return PrzesylkaProceduralnaType
     */
    public function setNumerNadaniaPowrot2($numerNadaniaPowrot2 = null)
    {
        $this->numerNadaniaPowrot2 = $numerNadaniaPowrot2;
        return $this;
    }
    /**
     * Get idPrzesylkaZawartosc value
     * @return int|null
     */
    public function getIdPrzesylkaZawartosc()
    {
        return $this->idPrzesylkaZawartosc;
    }
    /**
     * Set idPrzesylkaZawartosc value
     * @param int $idPrzesylkaZawartosc
     * @return PrzesylkaProceduralnaType
     */
    public function setIdPrzesylkaZawartosc($idPrzesylkaZawartosc = null)
    {
        $this->idPrzesylkaZawartosc = $idPrzesylkaZawartosc;
        return $this;
    }
    /**
     * Get idListaCzynnosci value
     * @return int|null
     */
    public function getIdListaCzynnosci()
    {
        return $this->idListaCzynnosci;
    }
    /**
     * Set idListaCzynnosci value
     * @param int $idListaCzynnosci
     * @return PrzesylkaProceduralnaType
     */
    public function setIdListaCzynnosci($idListaCzynnosci = null)
    {
        $this->idListaCzynnosci = $idListaCzynnosci;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return PrzesylkaProceduralnaType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get opakowanie value
     * @return string|null
     */
    public function getOpakowanie()
    {
        return $this->opakowanie;
    }
    /**
     * Set opakowanie value
     * @param string $opakowanie
     * @return PrzesylkaProceduralnaType
     */
    public function setOpakowanie($opakowanie = null)
    {
        $this->opakowanie = $opakowanie;
        return $this;
    }
    /**
     * Get numerPrzesylkiKlienta value
     * @return string|null
     */
    public function getNumerPrzesylkiKlienta()
    {
        return $this->numerPrzesylkiKlienta;
    }
    /**
     * Set numerPrzesylkiKlienta value
     * @param string $numerPrzesylkiKlienta
     * @return PrzesylkaProceduralnaType
     */
    public function setNumerPrzesylkiKlienta($numerPrzesylkiKlienta = null)
    {
        $this->numerPrzesylkiKlienta = $numerPrzesylkiKlienta;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return PrzesylkaProceduralnaType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get idAdresPrzesylkaPowrot value
     * @return int|null
     */
    public function getIdAdresPrzesylkaPowrot()
    {
        return $this->idAdresPrzesylkaPowrot;
    }
    /**
     * Set idAdresPrzesylkaPowrot value
     * @param int $idAdresPrzesylkaPowrot
     * @return PrzesylkaProceduralnaType
     */
    public function setIdAdresPrzesylkaPowrot($idAdresPrzesylkaPowrot = null)
    {
        $this->idAdresPrzesylkaPowrot = $idAdresPrzesylkaPowrot;
        return $this;
    }
}
