<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getEPOStatusResponse StructType
 * @subpackage Structs
 */
class GetEPOStatusResponse extends AbstractStructBase
{
    /**
     * The epo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var PrzesylkaEPOType[]
     */
    public $epo;
    /**
     * The error
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ErrorType[]
     */
    public $error;
    /**
     * Constructor method for getEPOStatusResponse
     * @uses GetEPOStatusResponse::setEpo()
     * @uses GetEPOStatusResponse::setError()
     * @param PrzesylkaEPOType[] $epo
     * @param ErrorType[] $error
     */
    public function __construct(array $epo = array(), array $error = array())
    {
        $this
            ->setEpo($epo)
            ->setError($error);
    }
    /**
     * Get epo value
     * @return PrzesylkaEPOType[]|null
     */
    public function getEpo()
    {
        return $this->epo;
    }
    /**
     * Set epo value
     * @param PrzesylkaEPOType[] $epo
     * @return GetEPOStatusResponse
     */
    public function setEpo(array $epo = array())
    {
        $this->epo = $epo;
        return $this;
    }
    /**
     * Add item to epo value
     * @throws \InvalidArgumentException
     * @param PrzesylkaEPOType $item
     * @return GetEPOStatusResponse
     */
    public function addToEpo(PrzesylkaEPOType $item)
    {
        $this->epo[] = $item;
        return $this;
    }
    /**
     * Get error value
     * @return ErrorType[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param ErrorType[] $error
     * @return GetEPOStatusResponse
     */
    public function setError(array $error = array())
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param ErrorType $item
     * @return GetEPOStatusResponse
     */
    public function addToError(ErrorType $item)
    {
        $this->error[] = $item;
        return $this;
    }
}
