<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for orderEasyReturnSolutionLabel StructType
 * @subpackage Structs
 */
class OrderEasyReturnSolutionLabel extends AbstractStructBase
{
    /**
     * The senderAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var AddressType
     */
    public $senderAddress;
    /**
     * The recipientAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var AddressType
     */
    public $recipientAddress;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - documentation: Shipment weight [g].
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $weight;
    /**
     * The customsDeclaration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var CustomsDeclarationType
     */
    public $customsDeclaration;
    /**
     * The deliveryMethod
     * Meta information extracted from the WSDL
     * - documentation: If not set, getPrintForParcel method should be used to get label.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DeliveryMethodType
     */
    public $deliveryMethod;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Description. maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * Constructor method for orderEasyReturnSolutionLabel
     * @uses OrderEasyReturnSolutionLabel::setSenderAddress()
     * @uses OrderEasyReturnSolutionLabel::setRecipientAddress()
     * @uses OrderEasyReturnSolutionLabel::setWeight()
     * @uses OrderEasyReturnSolutionLabel::setCustomsDeclaration()
     * @uses OrderEasyReturnSolutionLabel::setDeliveryMethod()
     * @uses OrderEasyReturnSolutionLabel::setDescription()
     * @param AddressType $senderAddress
     * @param AddressType $recipientAddress
     * @param int $weight
     * @param CustomsDeclarationType $customsDeclaration
     * @param DeliveryMethodType $deliveryMethod
     * @param string $description
     */
    public function __construct(AddressType $senderAddress = null, AddressType $recipientAddress = null, $weight = null, CustomsDeclarationType $customsDeclaration = null, DeliveryMethodType $deliveryMethod = null, $description = null)
    {
        $this
            ->setSenderAddress($senderAddress)
            ->setRecipientAddress($recipientAddress)
            ->setWeight($weight)
            ->setCustomsDeclaration($customsDeclaration)
            ->setDeliveryMethod($deliveryMethod)
            ->setDescription($description);
    }
    /**
     * Get senderAddress value
     * @return AddressType
     */
    public function getSenderAddress()
    {
        return $this->senderAddress;
    }
    /**
     * Set senderAddress value
     * @param AddressType $senderAddress
     * @return OrderEasyReturnSolutionLabel
     */
    public function setSenderAddress(AddressType $senderAddress = null)
    {
        $this->senderAddress = $senderAddress;
        return $this;
    }
    /**
     * Get recipientAddress value
     * @return AddressType
     */
    public function getRecipientAddress()
    {
        return $this->recipientAddress;
    }
    /**
     * Set recipientAddress value
     * @param AddressType $recipientAddress
     * @return OrderEasyReturnSolutionLabel
     */
    public function setRecipientAddress(AddressType $recipientAddress = null)
    {
        $this->recipientAddress = $recipientAddress;
        return $this;
    }
    /**
     * Get weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param int $weight
     * @return OrderEasyReturnSolutionLabel
     */
    public function setWeight($weight = null)
    {
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get customsDeclaration value
     * @return CustomsDeclarationType|null
     */
    public function getCustomsDeclaration()
    {
        return $this->customsDeclaration;
    }
    /**
     * Set customsDeclaration value
     * @param CustomsDeclarationType $customsDeclaration
     * @return OrderEasyReturnSolutionLabel
     */
    public function setCustomsDeclaration(CustomsDeclarationType $customsDeclaration = null)
    {
        $this->customsDeclaration = $customsDeclaration;
        return $this;
    }
    /**
     * Get deliveryMethod value
     * @return DeliveryMethodType|null
     */
    public function getDeliveryMethod()
    {
        return $this->deliveryMethod;
    }
    /**
     * Set deliveryMethod value
     * @param DeliveryMethodType $deliveryMethod
     * @return OrderEasyReturnSolutionLabel
     */
    public function setDeliveryMethod(DeliveryMethodType $deliveryMethod = null)
    {
        $this->deliveryMethod = $deliveryMethod;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return OrderEasyReturnSolutionLabel
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
}
