<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType StructType
 * Meta information extracted from the WSDL
 * - maxOccurs: 1
 * - minOccurs: 0
 * - type: xsd:string
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The firstNameOrCompanyName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstNameOrCompanyName;
    /**
     * The lastNameOrCompanyNameContinued
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastNameOrCompanyNameContinued;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseNumber;
    /**
     * The apartamentNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $apartamentNumber;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 63
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The zipCode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $zipCode;
    /**
     * The countryCode
     * Meta information extracted from the WSDL
     * - documentation: Code (ISO 3166) of the country.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $countryCode;
    /**
     * The mobile
     * Meta information extracted from the WSDL
     * - documentation: źródło danych: http://www.uke.gov.pl/tablice/NumerPlmn-list.do?execution=e5s1 -- wygenerowano 2017-10-13 14:29:07
     * - base: xsd:string
     * - length: 9
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (45|50|51|53|57|60|66|69|72|73|78|79|88)[0-9]{7}
     * @var string
     */
    public $mobile;
    /**
     * The telephone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $telephone;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 6
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The contactPerson
     * @var string
     */
    public $contactPerson;
    /**
     * The nip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nip;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setFirstNameOrCompanyName()
     * @uses AddressType::setLastNameOrCompanyNameContinued()
     * @uses AddressType::setStreet()
     * @uses AddressType::setHouseNumber()
     * @uses AddressType::setApartamentNumber()
     * @uses AddressType::setCity()
     * @uses AddressType::setZipCode()
     * @uses AddressType::setCountryCode()
     * @uses AddressType::setMobile()
     * @uses AddressType::setTelephone()
     * @uses AddressType::setEmail()
     * @uses AddressType::setContactPerson()
     * @uses AddressType::setNip()
     * @param string $firstNameOrCompanyName
     * @param string $lastNameOrCompanyNameContinued
     * @param string $street
     * @param string $houseNumber
     * @param string $apartamentNumber
     * @param string $city
     * @param string $zipCode
     * @param string $countryCode
     * @param string $mobile
     * @param string $telephone
     * @param string $email
     * @param string $contactPerson
     * @param string $nip
     */
    public function __construct($firstNameOrCompanyName = null, $lastNameOrCompanyNameContinued = null, $street = null, $houseNumber = null, $apartamentNumber = null, $city = null, $zipCode = null, $countryCode = null, $mobile = null, $telephone = null, $email = null, $contactPerson = null, $nip = null)
    {
        $this
            ->setFirstNameOrCompanyName($firstNameOrCompanyName)
            ->setLastNameOrCompanyNameContinued($lastNameOrCompanyNameContinued)
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setApartamentNumber($apartamentNumber)
            ->setCity($city)
            ->setZipCode($zipCode)
            ->setCountryCode($countryCode)
            ->setMobile($mobile)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setContactPerson($contactPerson)
            ->setNip($nip);
    }
    /**
     * Get firstNameOrCompanyName value
     * @return string|null
     */
    public function getFirstNameOrCompanyName()
    {
        return $this->firstNameOrCompanyName;
    }
    /**
     * Set firstNameOrCompanyName value
     * @param string $firstNameOrCompanyName
     * @return AddressType
     */
    public function setFirstNameOrCompanyName($firstNameOrCompanyName = null)
    {
        $this->firstNameOrCompanyName = $firstNameOrCompanyName;
        return $this;
    }
    /**
     * Get lastNameOrCompanyNameContinued value
     * @return string|null
     */
    public function getLastNameOrCompanyNameContinued()
    {
        return $this->lastNameOrCompanyNameContinued;
    }
    /**
     * Set lastNameOrCompanyNameContinued value
     * @param string $lastNameOrCompanyNameContinued
     * @return AddressType
     */
    public function setLastNameOrCompanyNameContinued($lastNameOrCompanyNameContinued = null)
    {
        $this->lastNameOrCompanyNameContinued = $lastNameOrCompanyNameContinued;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return AddressType
     */
    public function setStreet($street = null)
    {
        $this->street = $street;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return AddressType
     */
    public function setHouseNumber($houseNumber = null)
    {
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get apartamentNumber value
     * @return string|null
     */
    public function getApartamentNumber()
    {
        return $this->apartamentNumber;
    }
    /**
     * Set apartamentNumber value
     * @param string $apartamentNumber
     * @return AddressType
     */
    public function setApartamentNumber($apartamentNumber = null)
    {
        $this->apartamentNumber = $apartamentNumber;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return AddressType
     */
    public function setCity($city = null)
    {
        $this->city = $city;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return AddressType
     */
    public function setZipCode($zipCode = null)
    {
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return AddressType
     */
    public function setCountryCode($countryCode = null)
    {
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->mobile;
    }
    /**
     * Set mobile value
     * @param string $mobile
     * @return AddressType
     */
    public function setMobile($mobile = null)
    {
        $this->mobile = $mobile;
        return $this;
    }
    /**
     * Get telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->telephone;
    }
    /**
     * Set telephone value
     * @param string $telephone
     * @return AddressType
     */
    public function setTelephone($telephone = null)
    {
        $this->telephone = $telephone;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return AddressType
     */
    public function setEmail($email = null)
    {
        $this->email = $email;
        return $this;
    }
    /**
     * Get contactPerson value
     * @return string|null
     */
    public function getContactPerson()
    {
        return $this->contactPerson;
    }
    /**
     * Set contactPerson value
     * @param string $contactPerson
     * @return AddressType
     */
    public function setContactPerson($contactPerson = null)
    {
        $this->contactPerson = $contactPerson;
        return $this;
    }
    /**
     * Get nip value
     * @return string|null
     */
    public function getNip()
    {
        return $this->nip;
    }
    /**
     * Set nip value
     * @param string $nip
     * @return AddressType
     */
    public function setNip($nip = null)
    {
        $this->nip = $nip;
        return $this;
    }
}
