<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for przesylkaRejestrowanaType StructType
 * @subpackage Structs
 */
abstract class PrzesylkaRejestrowanaType extends PrzesylkaType
{
    /**
     * The adres
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AdresType
     */
    public $adres;
    /**
     * The nadawca
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AdresType
     */
    public $nadawca;
    /**
     * The relatedToAllegro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RelatedToAllegroType
     */
    public $relatedToAllegro;
    /**
     * The numerNadania
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 13
     * @var string
     */
    public $numerNadania;
    /**
     * The sygnatura
     * Meta information extracted from the WSDL
     * - documentation: sygnatura np. sprawy/pisma nadanego przesyłką
     * - base: xsd:string
     * - maxLength: 255
     * - minLength: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $sygnatura;
    /**
     * The terminSprawy
     * Meta information extracted from the WSDL
     * - documentation: termin np. rozprawy sądowej lub termin graniczny pisma nadanego przesyłką
     * - base: xsd:string
     * @var string
     */
    public $terminSprawy;
    /**
     * The rodzaj
     * Meta information extracted from the WSDL
     * - documentation: rodzaj przesyłki klienta np. postepowanie karne, cywilne, reklamacja, odwołanie, wezwanie do zapłaty itp.
     * - base: xsd:string
     * - maxLength: 255
     * - minLength: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $rodzaj;
    /**
     * The weryfikacjaPlatnosci
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $weryfikacjaPlatnosci;
    /**
     * Constructor method for przesylkaRejestrowanaType
     * @uses PrzesylkaRejestrowanaType::setAdres()
     * @uses PrzesylkaRejestrowanaType::setNadawca()
     * @uses PrzesylkaRejestrowanaType::setRelatedToAllegro()
     * @uses PrzesylkaRejestrowanaType::setNumerNadania()
     * @uses PrzesylkaRejestrowanaType::setSygnatura()
     * @uses PrzesylkaRejestrowanaType::setTerminSprawy()
     * @uses PrzesylkaRejestrowanaType::setRodzaj()
     * @uses PrzesylkaRejestrowanaType::setWeryfikacjaPlatnosci()
     * @param AdresType $adres
     * @param AdresType $nadawca
     * @param RelatedToAllegroType $relatedToAllegro
     * @param string $numerNadania
     * @param string $sygnatura
     * @param string $terminSprawy
     * @param string $rodzaj
     * @param bool $weryfikacjaPlatnosci
     */
    public function __construct(AdresType $adres = null, AdresType $nadawca = null, RelatedToAllegroType $relatedToAllegro = null, $numerNadania = null, $sygnatura = null, $terminSprawy = null, $rodzaj = null, $weryfikacjaPlatnosci = null)
    {
        $this
            ->setAdres($adres)
            ->setNadawca($nadawca)
            ->setRelatedToAllegro($relatedToAllegro)
            ->setNumerNadania($numerNadania)
            ->setSygnatura($sygnatura)
            ->setTerminSprawy($terminSprawy)
            ->setRodzaj($rodzaj)
            ->setWeryfikacjaPlatnosci($weryfikacjaPlatnosci);
    }
    /**
     * Get adres value
     * @return AdresType|null
     */
    public function getAdres()
    {
        return $this->adres;
    }
    /**
     * Set adres value
     * @param AdresType $adres
     * @return PrzesylkaRejestrowanaType
     */
    public function setAdres(AdresType $adres = null)
    {
        $this->adres = $adres;
        return $this;
    }
    /**
     * Get nadawca value
     * @return AdresType|null
     */
    public function getNadawca()
    {
        return $this->nadawca;
    }
    /**
     * Set nadawca value
     * @param AdresType $nadawca
     * @return PrzesylkaRejestrowanaType
     */
    public function setNadawca(AdresType $nadawca = null)
    {
        $this->nadawca = $nadawca;
        return $this;
    }
    /**
     * Get relatedToAllegro value
     * @return RelatedToAllegroType|null
     */
    public function getRelatedToAllegro()
    {
        return $this->relatedToAllegro;
    }
    /**
     * Set relatedToAllegro value
     * @param RelatedToAllegroType $relatedToAllegro
     * @return PrzesylkaRejestrowanaType
     */
    public function setRelatedToAllegro(RelatedToAllegroType $relatedToAllegro = null)
    {
        $this->relatedToAllegro = $relatedToAllegro;
        return $this;
    }
    /**
     * Get numerNadania value
     * @return string|null
     */
    public function getNumerNadania()
    {
        return $this->numerNadania;
    }
    /**
     * Set numerNadania value
     * @param string $numerNadania
     * @return PrzesylkaRejestrowanaType
     */
    public function setNumerNadania($numerNadania = null)
    {
        $this->numerNadania = $numerNadania;
        return $this;
    }
    /**
     * Get sygnatura value
     * @return string|null
     */
    public function getSygnatura()
    {
        return $this->sygnatura;
    }
    /**
     * Set sygnatura value
     * @param string $sygnatura
     * @return PrzesylkaRejestrowanaType
     */
    public function setSygnatura($sygnatura = null)
    {
        $this->sygnatura = $sygnatura;
        return $this;
    }
    /**
     * Get terminSprawy value
     * @return string|null
     */
    public function getTerminSprawy()
    {
        return $this->terminSprawy;
    }
    /**
     * Set terminSprawy value
     * @param string $terminSprawy
     * @return PrzesylkaRejestrowanaType
     */
    public function setTerminSprawy($terminSprawy = null)
    {
        $this->terminSprawy = $terminSprawy;
        return $this;
    }
    /**
     * Get rodzaj value
     * @return string|null
     */
    public function getRodzaj()
    {
        return $this->rodzaj;
    }
    /**
     * Set rodzaj value
     * @param string $rodzaj
     * @return PrzesylkaRejestrowanaType
     */
    public function setRodzaj($rodzaj = null)
    {
        $this->rodzaj = $rodzaj;
        return $this;
    }
    /**
     * Get weryfikacjaPlatnosci value
     * @return bool|null
     */
    public function getWeryfikacjaPlatnosci()
    {
        return $this->weryfikacjaPlatnosci;
    }
    /**
     * Set weryfikacjaPlatnosci value
     * @param bool $weryfikacjaPlatnosci
     * @return PrzesylkaRejestrowanaType
     */
    public function setWeryfikacjaPlatnosci($weryfikacjaPlatnosci = null)
    {
        $this->weryfikacjaPlatnosci = $weryfikacjaPlatnosci;
        return $this;
    }
}
