<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createParcelContentResponse StructType
 * @subpackage Structs
 */
class CreateParcelContentResponse extends AbstractStructBase
{
    /**
     * The parcelContent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ParcelContentType[]
     */
    public $parcelContent;
    /**
     * The error
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ErrorType[]
     */
    public $error;
    /**
     * Constructor method for createParcelContentResponse
     * @uses CreateParcelContentResponse::setParcelContent()
     * @uses CreateParcelContentResponse::setError()
     * @param ParcelContentType[] $parcelContent
     * @param ErrorType[] $error
     */
    public function __construct(array $parcelContent = array(), array $error = array())
    {
        $this
            ->setParcelContent($parcelContent)
            ->setError($error);
    }
    /**
     * Get parcelContent value
     * @return ParcelContentType[]|null
     */
    public function getParcelContent()
    {
        return $this->parcelContent;
    }
    /**
     * Set parcelContent value
     * @param ParcelContentType[] $parcelContent
     * @return CreateParcelContentResponse
     */
    public function setParcelContent(array $parcelContent = array())
    {
        $this->parcelContent = $parcelContent;
        return $this;
    }
    /**
     * Add item to parcelContent value
     * @throws \InvalidArgumentException
     * @param ParcelContentType $item
     * @return CreateParcelContentResponse
     */
    public function addToParcelContent(ParcelContentType $item)
    {
        $this->parcelContent[] = $item;
        return $this;
    }
    /**
     * Get error value
     * @return ErrorType[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param ErrorType[] $error
     * @return CreateParcelContentResponse
     */
    public function setError(array $error = array())
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param ErrorType $item
     * @return CreateParcelContentResponse
     */
    public function addToError(ErrorType $item)
    {
        $this->error[] = $item;
        return $this;
    }
}
