<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subPrzesylkaBiznesowaType StructType
 * @subpackage Structs
 */
class SubPrzesylkaBiznesowaType extends PrzesylkaType
{
    /**
     * The ubezpieczenie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UbezpieczenieType
     */
    public $ubezpieczenie;
    /**
     * The numerNadania
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 13
     * @var string
     */
    public $numerNadania;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The gabaryt
     * @var string
     */
    public $gabaryt;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $wartosc;
    /**
     * The ostroznie
     * @var bool
     */
    public $ostroznie;
    /**
     * The numerPrzesylkiKlienta
     * @var string
     */
    public $numerPrzesylkiKlienta;
    /**
     * The niestandardowa
     * Meta information extracted from the WSDL
     * - documentation: TRUE jeżeli przesyłka niestandardowa. Za przesyłkę niestandardową uważa się przesyłkę spełniającą przynajmniej jedno z poniższych kryteriów: wymiary wynoszące 250 cm < (a+b+c) <= 300 cm, przy czym dł. maks. = 150 cm,
     * wymiary wynoszące (a+b+c) $lte; 250 cm, przy czym dł. maks. = 150 cm, posiadającej: - nieregularne kształty lub - wystające elementy, lub - składającej się z dwóch odrębnych części, połączonych w jedną nieregularną całość (np. za
     * pomocą folii stretch, taśmy itp.).
     * @var bool
     */
    public $niestandardowa;
    /**
     * Constructor method for subPrzesylkaBiznesowaType
     * @uses SubPrzesylkaBiznesowaType::setUbezpieczenie()
     * @uses SubPrzesylkaBiznesowaType::setNumerNadania()
     * @uses SubPrzesylkaBiznesowaType::setMasa()
     * @uses SubPrzesylkaBiznesowaType::setGabaryt()
     * @uses SubPrzesylkaBiznesowaType::setWartosc()
     * @uses SubPrzesylkaBiznesowaType::setOstroznie()
     * @uses SubPrzesylkaBiznesowaType::setNumerPrzesylkiKlienta()
     * @uses SubPrzesylkaBiznesowaType::setNiestandardowa()
     * @param UbezpieczenieType $ubezpieczenie
     * @param string $numerNadania
     * @param int $masa
     * @param string $gabaryt
     * @param int $wartosc
     * @param bool $ostroznie
     * @param string $numerPrzesylkiKlienta
     * @param bool $niestandardowa
     */
    public function __construct(UbezpieczenieType $ubezpieczenie = null, $numerNadania = null, $masa = null, $gabaryt = null, $wartosc = null, $ostroznie = null, $numerPrzesylkiKlienta = null, $niestandardowa = null)
    {
        $this
            ->setUbezpieczenie($ubezpieczenie)
            ->setNumerNadania($numerNadania)
            ->setMasa($masa)
            ->setGabaryt($gabaryt)
            ->setWartosc($wartosc)
            ->setOstroznie($ostroznie)
            ->setNumerPrzesylkiKlienta($numerPrzesylkiKlienta)
            ->setNiestandardowa($niestandardowa);
    }
    /**
     * Get ubezpieczenie value
     * @return UbezpieczenieType|null
     */
    public function getUbezpieczenie()
    {
        return $this->ubezpieczenie;
    }
    /**
     * Set ubezpieczenie value
     * @param UbezpieczenieType $ubezpieczenie
     * @return SubPrzesylkaBiznesowaType
     */
    public function setUbezpieczenie(UbezpieczenieType $ubezpieczenie = null)
    {
        $this->ubezpieczenie = $ubezpieczenie;
        return $this;
    }
    /**
     * Get numerNadania value
     * @return string|null
     */
    public function getNumerNadania()
    {
        return $this->numerNadania;
    }
    /**
     * Set numerNadania value
     * @param string $numerNadania
     * @return SubPrzesylkaBiznesowaType
     */
    public function setNumerNadania($numerNadania = null)
    {
        $this->numerNadania = $numerNadania;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return SubPrzesylkaBiznesowaType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get gabaryt value
     * @return string|null
     */
    public function getGabaryt()
    {
        return $this->gabaryt;
    }
    /**
     * Set gabaryt value
     * @param string $gabaryt
     * @return SubPrzesylkaBiznesowaType
     */
    public function setGabaryt($gabaryt = null)
    {
        $this->gabaryt = $gabaryt;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return SubPrzesylkaBiznesowaType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get ostroznie value
     * @return bool|null
     */
    public function getOstroznie()
    {
        return $this->ostroznie;
    }
    /**
     * Set ostroznie value
     * @param bool $ostroznie
     * @return SubPrzesylkaBiznesowaType
     */
    public function setOstroznie($ostroznie = null)
    {
        $this->ostroznie = $ostroznie;
        return $this;
    }
    /**
     * Get numerPrzesylkiKlienta value
     * @return string|null
     */
    public function getNumerPrzesylkiKlienta()
    {
        return $this->numerPrzesylkiKlienta;
    }
    /**
     * Set numerPrzesylkiKlienta value
     * @param string $numerPrzesylkiKlienta
     * @return SubPrzesylkaBiznesowaType
     */
    public function setNumerPrzesylkiKlienta($numerPrzesylkiKlienta = null)
    {
        $this->numerPrzesylkiKlienta = $numerPrzesylkiKlienta;
        return $this;
    }
    /**
     * Get niestandardowa value
     * @return bool|null
     */
    public function getNiestandardowa()
    {
        return $this->niestandardowa;
    }
    /**
     * Set niestandardowa value
     * @param bool $niestandardowa
     * @return SubPrzesylkaBiznesowaType
     */
    public function setNiestandardowa($niestandardowa = null)
    {
        $this->niestandardowa = $niestandardowa;
        return $this;
    }
}
