<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentContentsDetailsType StructType
 * @subpackage Structs
 */
class ShipmentContentsDetailsType extends AbstractStructBase
{
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $quantity;
    /**
     * The declaredValue
     * Meta information extracted from the WSDL
     * - documentation: Declared value of a given type of goods, without the decimal point, e.g. 20000 cents.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $declaredValue;
    /**
     * The netWeight
     * Meta information extracted from the WSDL
     * - documentation: Net weight [g].
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $netWeight;
    /**
     * The harmonizedSystemCode
     * Meta information extracted from the WSDL
     * - documentation: Harmonized System (HS) Code.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{1,10}
     * @var string
     */
    public $harmonizedSystemCode;
    /**
     * The originLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Code (ISO 3166) of the country of origin of the described content. example: US
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $originLocationCode;
    /**
     * Constructor method for ShipmentContentsDetailsType
     * @uses ShipmentContentsDetailsType::setDescription()
     * @uses ShipmentContentsDetailsType::setQuantity()
     * @uses ShipmentContentsDetailsType::setDeclaredValue()
     * @uses ShipmentContentsDetailsType::setNetWeight()
     * @uses ShipmentContentsDetailsType::setHarmonizedSystemCode()
     * @uses ShipmentContentsDetailsType::setOriginLocationCode()
     * @param string $description
     * @param int $quantity
     * @param int $declaredValue
     * @param int $netWeight
     * @param string $harmonizedSystemCode
     * @param string $originLocationCode
     */
    public function __construct($description = null, $quantity = null, $declaredValue = null, $netWeight = null, $harmonizedSystemCode = null, $originLocationCode = null)
    {
        $this
            ->setDescription($description)
            ->setQuantity($quantity)
            ->setDeclaredValue($declaredValue)
            ->setNetWeight($netWeight)
            ->setHarmonizedSystemCode($harmonizedSystemCode)
            ->setOriginLocationCode($originLocationCode);
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return ShipmentContentsDetailsType
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return ShipmentContentsDetailsType
     */
    public function setQuantity($quantity = null)
    {
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get declaredValue value
     * @return int
     */
    public function getDeclaredValue()
    {
        return $this->declaredValue;
    }
    /**
     * Set declaredValue value
     * @param int $declaredValue
     * @return ShipmentContentsDetailsType
     */
    public function setDeclaredValue($declaredValue = null)
    {
        $this->declaredValue = $declaredValue;
        return $this;
    }
    /**
     * Get netWeight value
     * @return int|null
     */
    public function getNetWeight()
    {
        return $this->netWeight;
    }
    /**
     * Set netWeight value
     * @param int $netWeight
     * @return ShipmentContentsDetailsType
     */
    public function setNetWeight($netWeight = null)
    {
        $this->netWeight = $netWeight;
        return $this;
    }
    /**
     * Get harmonizedSystemCode value
     * @return string|null
     */
    public function getHarmonizedSystemCode()
    {
        return $this->harmonizedSystemCode;
    }
    /**
     * Set harmonizedSystemCode value
     * @param string $harmonizedSystemCode
     * @return ShipmentContentsDetailsType
     */
    public function setHarmonizedSystemCode($harmonizedSystemCode = null)
    {
        $this->harmonizedSystemCode = $harmonizedSystemCode;
        return $this;
    }
    /**
     * Get originLocationCode value
     * @return string|null
     */
    public function getOriginLocationCode()
    {
        return $this->originLocationCode;
    }
    /**
     * Set originLocationCode value
     * @param string $originLocationCode
     * @return ShipmentContentsDetailsType
     */
    public function setOriginLocationCode($originLocationCode = null)
    {
        $this->originLocationCode = $originLocationCode;
        return $this;
    }
}
