<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kartaType StructType
 * @subpackage Structs
 */
class KartaType extends AbstractStructBase
{
    /**
     * The adresKorespondencyjny
     * Meta information extracted from the WSDL
     * - documentation: Lista adresów korespondencyjnych dla kart typu 2
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var AdresKorespondencyjny[]
     */
    public $adresKorespondencyjny;
    /**
     * The idKarta
     * @var int
     */
    public $idKarta;
    /**
     * The opis
     * @var string
     */
    public $opis;
    /**
     * The aktywna
     * @var bool
     */
    public $aktywna;
    /**
     * The typ
     * Meta information extracted from the WSDL
     * - documentation: Typ karty. Dopuszczalne wartości: 1-do nadawania, 2-do definicji adresów OPNA. Lista obsługiwanych wartości może być rozszerzona w przyszłości.
     * @var int
     */
    public $typ;
    /**
     * Constructor method for kartaType
     * @uses KartaType::setAdresKorespondencyjny()
     * @uses KartaType::setIdKarta()
     * @uses KartaType::setOpis()
     * @uses KartaType::setAktywna()
     * @uses KartaType::setTyp()
     * @param AdresKorespondencyjny[] $adresKorespondencyjny
     * @param int $idKarta
     * @param string $opis
     * @param bool $aktywna
     * @param int $typ
     */
    public function __construct(array $adresKorespondencyjny = array(), $idKarta = null, $opis = null, $aktywna = null, $typ = null)
    {
        $this
            ->setAdresKorespondencyjny($adresKorespondencyjny)
            ->setIdKarta($idKarta)
            ->setOpis($opis)
            ->setAktywna($aktywna)
            ->setTyp($typ);
    }
    /**
     * Get adresKorespondencyjny value
     * @return AdresKorespondencyjny[]|null
     */
    public function getAdresKorespondencyjny()
    {
        return $this->adresKorespondencyjny;
    }
    /**
     * Set adresKorespondencyjny value
     * @param AdresKorespondencyjny[] $adresKorespondencyjny
     * @return KartaType
     */
    public function setAdresKorespondencyjny(array $adresKorespondencyjny = array())
    {
        $this->adresKorespondencyjny = $adresKorespondencyjny;
        return $this;
    }
    /**
     * Add item to adresKorespondencyjny value
     * @throws \InvalidArgumentException
     * @param AdresKorespondencyjny $item
     * @return KartaType
     */
    public function addToAdresKorespondencyjny(AdresKorespondencyjny $item)
    {
        $this->adresKorespondencyjny[] = $item;
        return $this;
    }
    /**
     * Get idKarta value
     * @return int|null
     */
    public function getIdKarta()
    {
        return $this->idKarta;
    }
    /**
     * Set idKarta value
     * @param int $idKarta
     * @return KartaType
     */
    public function setIdKarta($idKarta = null)
    {
        $this->idKarta = $idKarta;
        return $this;
    }
    /**
     * Get opis value
     * @return string|null
     */
    public function getOpis()
    {
        return $this->opis;
    }
    /**
     * Set opis value
     * @param string $opis
     * @return KartaType
     */
    public function setOpis($opis = null)
    {
        $this->opis = $opis;
        return $this;
    }
    /**
     * Get aktywna value
     * @return bool|null
     */
    public function getAktywna()
    {
        return $this->aktywna;
    }
    /**
     * Set aktywna value
     * @param bool $aktywna
     * @return KartaType
     */
    public function setAktywna($aktywna = null)
    {
        $this->aktywna = $aktywna;
        return $this;
    }
    /**
     * Get typ value
     * @return int|null
     */
    public function getTyp()
    {
        return $this->typ;
    }
    /**
     * Set typ value
     * @param int $typ
     * @return KartaType
     */
    public function setTyp($typ = null)
    {
        $this->typ = $typ;
        return $this;
    }
}
