<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EMSType StructType
 * @subpackage Structs
 */
class EMSType extends PrzesylkaRejestrowanaType
{
    /**
     * The ubezpieczenie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UbezpieczenieType
     */
    public $ubezpieczenie;
    /**
     * The deklaracjaCelna
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DeklaracjaCelnaType
     */
    public $deklaracjaCelna;
    /**
     * The potwierdzenieDoreczenia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PotwierdzenieDoreczeniaType
     */
    public $potwierdzenieDoreczenia;
    /**
     * The deklaracjaCelna2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DeklaracjaCelna2Type
     */
    public $deklaracjaCelna2;
    /**
     * The sposobNadaniaInterconnect
     * Meta information extracted from the WSDL
     * - documentation: Umożliwia określenie sposobu nadania przesyłki w ramach systemu Interconnect.Obsługiwane wartości:- ODBIOR_Z_ADRESU_PRYWATNEGO- ODBIOR_Z_ADRESU_FIRMOWEGO- NADANIE_W_PLACOWCE_POCZTOWEJ
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sposobNadaniaInterconnect;
    /**
     * The sposobDoreczenia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var SposobDoreczeniaType
     */
    public $sposobDoreczenia;
    /**
     * The typOpakowania
     * @var string
     */
    public $typOpakowania;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The zalaczoneDokumenty
     * @var bool
     */
    public $zalaczoneDokumenty;
    /**
     * The numerPrzesylkiKlienta
     * @var string
     */
    public $numerPrzesylkiKlienta;
    /**
     * Constructor method for EMSType
     * @uses EMSType::setUbezpieczenie()
     * @uses EMSType::setDeklaracjaCelna()
     * @uses EMSType::setPotwierdzenieDoreczenia()
     * @uses EMSType::setDeklaracjaCelna2()
     * @uses EMSType::setSposobNadaniaInterconnect()
     * @uses EMSType::setSposobDoreczenia()
     * @uses EMSType::setTypOpakowania()
     * @uses EMSType::setMasa()
     * @uses EMSType::setZalaczoneDokumenty()
     * @uses EMSType::setNumerPrzesylkiKlienta()
     * @param UbezpieczenieType $ubezpieczenie
     * @param DeklaracjaCelnaType $deklaracjaCelna
     * @param PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia
     * @param DeklaracjaCelna2Type $deklaracjaCelna2
     * @param string $sposobNadaniaInterconnect
     * @param SposobDoreczeniaType $sposobDoreczenia
     * @param string $typOpakowania
     * @param int $masa
     * @param bool $zalaczoneDokumenty
     * @param string $numerPrzesylkiKlienta
     */
    public function __construct(UbezpieczenieType $ubezpieczenie = null, DeklaracjaCelnaType $deklaracjaCelna = null, PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia = null, DeklaracjaCelna2Type $deklaracjaCelna2 = null, $sposobNadaniaInterconnect = null, SposobDoreczeniaType $sposobDoreczenia = null, $typOpakowania = null, $masa = null, $zalaczoneDokumenty = null, $numerPrzesylkiKlienta = null)
    {
        $this
            ->setUbezpieczenie($ubezpieczenie)
            ->setDeklaracjaCelna($deklaracjaCelna)
            ->setPotwierdzenieDoreczenia($potwierdzenieDoreczenia)
            ->setDeklaracjaCelna2($deklaracjaCelna2)
            ->setSposobNadaniaInterconnect($sposobNadaniaInterconnect)
            ->setSposobDoreczenia($sposobDoreczenia)
            ->setTypOpakowania($typOpakowania)
            ->setMasa($masa)
            ->setZalaczoneDokumenty($zalaczoneDokumenty)
            ->setNumerPrzesylkiKlienta($numerPrzesylkiKlienta);
    }
    /**
     * Get ubezpieczenie value
     * @return UbezpieczenieType|null
     */
    public function getUbezpieczenie()
    {
        return $this->ubezpieczenie;
    }
    /**
     * Set ubezpieczenie value
     * @param UbezpieczenieType $ubezpieczenie
     * @return EMSType
     */
    public function setUbezpieczenie(UbezpieczenieType $ubezpieczenie = null)
    {
        $this->ubezpieczenie = $ubezpieczenie;
        return $this;
    }
    /**
     * Get deklaracjaCelna value
     * @return DeklaracjaCelnaType|null
     */
    public function getDeklaracjaCelna()
    {
        return $this->deklaracjaCelna;
    }
    /**
     * Set deklaracjaCelna value
     * @param DeklaracjaCelnaType $deklaracjaCelna
     * @return EMSType
     */
    public function setDeklaracjaCelna(DeklaracjaCelnaType $deklaracjaCelna = null)
    {
        $this->deklaracjaCelna = $deklaracjaCelna;
        return $this;
    }
    /**
     * Get potwierdzenieDoreczenia value
     * @return PotwierdzenieDoreczeniaType|null
     */
    public function getPotwierdzenieDoreczenia()
    {
        return $this->potwierdzenieDoreczenia;
    }
    /**
     * Set potwierdzenieDoreczenia value
     * @param PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia
     * @return EMSType
     */
    public function setPotwierdzenieDoreczenia(PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia = null)
    {
        $this->potwierdzenieDoreczenia = $potwierdzenieDoreczenia;
        return $this;
    }
    /**
     * Get deklaracjaCelna2 value
     * @return DeklaracjaCelna2Type|null
     */
    public function getDeklaracjaCelna2()
    {
        return $this->deklaracjaCelna2;
    }
    /**
     * Set deklaracjaCelna2 value
     * @param DeklaracjaCelna2Type $deklaracjaCelna2
     * @return EMSType
     */
    public function setDeklaracjaCelna2(DeklaracjaCelna2Type $deklaracjaCelna2 = null)
    {
        $this->deklaracjaCelna2 = $deklaracjaCelna2;
        return $this;
    }
    /**
     * Get sposobNadaniaInterconnect value
     * @return string|null
     */
    public function getSposobNadaniaInterconnect()
    {
        return $this->sposobNadaniaInterconnect;
    }
    /**
     * Set sposobNadaniaInterconnect value
     * @param string $sposobNadaniaInterconnect
     * @return EMSType
     */
    public function setSposobNadaniaInterconnect($sposobNadaniaInterconnect = null)
    {
        $this->sposobNadaniaInterconnect = $sposobNadaniaInterconnect;
        return $this;
    }
    /**
     * Get sposobDoreczenia value
     * @return SposobDoreczeniaType|null
     */
    public function getSposobDoreczenia()
    {
        return $this->sposobDoreczenia;
    }
    /**
     * Set sposobDoreczenia value
     * @param SposobDoreczeniaType $sposobDoreczenia
     * @return EMSType
     */
    public function setSposobDoreczenia(SposobDoreczeniaType $sposobDoreczenia = null)
    {
        $this->sposobDoreczenia = $sposobDoreczenia;
        return $this;
    }
    /**
     * Get typOpakowania value
     * @return string|null
     */
    public function getTypOpakowania()
    {
        return $this->typOpakowania;
    }
    /**
     * Set typOpakowania value
     * @param string $typOpakowania
     * @return EMSType
     */
    public function setTypOpakowania($typOpakowania = null)
    {
        $this->typOpakowania = $typOpakowania;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return EMSType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get zalaczoneDokumenty value
     * @return bool|null
     */
    public function getZalaczoneDokumenty()
    {
        return $this->zalaczoneDokumenty;
    }
    /**
     * Set zalaczoneDokumenty value
     * @param bool $zalaczoneDokumenty
     * @return EMSType
     */
    public function setZalaczoneDokumenty($zalaczoneDokumenty = null)
    {
        $this->zalaczoneDokumenty = $zalaczoneDokumenty;
        return $this;
    }
    /**
     * Get numerPrzesylkiKlienta value
     * @return string|null
     */
    public function getNumerPrzesylkiKlienta()
    {
        return $this->numerPrzesylkiKlienta;
    }
    /**
     * Set numerPrzesylkiKlienta value
     * @param string $numerPrzesylkiKlienta
     * @return EMSType
     */
    public function setNumerPrzesylkiKlienta($numerPrzesylkiKlienta = null)
    {
        $this->numerPrzesylkiKlienta = $numerPrzesylkiKlienta;
        return $this;
    }
}
