<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for przesylkaBiznesowaPlusType StructType
 * @subpackage Structs
 */
class PrzesylkaBiznesowaPlusType extends PrzesylkaRejestrowanaType
{
    /**
     * The pobranie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PobranieType
     */
    public $pobranie;
    /**
     * The urzadWydaniaPrzesylki
     * Meta information extracted from the WSDL
     * - documentation: Wystarczy przesłac obiekt z ustawionym id reszta pól moż ezostać pominięta (aby zmniejszyć ilośc danych do tansmisji)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PlacowkaPocztowaType
     */
    public $urzadWydaniaPrzesylki;
    /**
     * The subPrzesylka
     * Meta information extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var SubPrzesylkaBiznesowaPlusType[]
     */
    public $subPrzesylka;
    /**
     * The dataDrugiejProbyDoreczenia
     * Meta information extracted from the WSDL
     * - choice: dataDrugiejProbyDoreczenia | drugaProbaDoreczeniaPoLiczbieDni
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var string
     */
    public $dataDrugiejProbyDoreczenia;
    /**
     * The drugaProbaDoreczeniaPoLiczbieDni
     * Meta information extracted from the WSDL
     * - choice: dataDrugiejProbyDoreczenia | drugaProbaDoreczeniaPoLiczbieDni
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var int
     */
    public $drugaProbaDoreczeniaPoLiczbieDni;
    /**
     * The posteRestante
     * @var bool
     */
    public $posteRestante;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The gabaryt
     * @var string
     */
    public $gabaryt;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $wartosc;
    /**
     * The kwotaTranzakcji
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $kwotaTranzakcji;
    /**
     * The ostroznie
     * @var bool
     */
    public $ostroznie;
    /**
     * The kategoria
     * @var string
     */
    public $kategoria;
    /**
     * The iloscPotwierdzenOdbioru
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxInclusive: 9
     * - minInclusive: 0
     * @var int
     */
    public $iloscPotwierdzenOdbioru;
    /**
     * The eKontaktAdresata
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - minLength: 0
     * @var string
     */
    public $eKontaktAdresata;
    /**
     * The eSposobPowiadomieniaAdresata
     * @var string
     */
    public $eSposobPowiadomieniaAdresata;
    /**
     * The numerPrzesylkiKlienta
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 25
     * @var string
     */
    public $numerPrzesylkiKlienta;
    /**
     * The iloscDniOczekiwaniaNaWydanie
     * @var int
     */
    public $iloscDniOczekiwaniaNaWydanie;
    /**
     * The oczekiwanyTerminDoreczenia
     * @var string
     */
    public $oczekiwanyTerminDoreczenia;
    /**
     * The terminRodzajPlus
     * @var string
     */
    public $terminRodzajPlus;
    /**
     * The numerTransakcjiOdbioru
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $numerTransakcjiOdbioru;
    /**
     * Constructor method for przesylkaBiznesowaPlusType
     * @uses PrzesylkaBiznesowaPlusType::setPobranie()
     * @uses PrzesylkaBiznesowaPlusType::setUrzadWydaniaPrzesylki()
     * @uses PrzesylkaBiznesowaPlusType::setSubPrzesylka()
     * @uses PrzesylkaBiznesowaPlusType::setDataDrugiejProbyDoreczenia()
     * @uses PrzesylkaBiznesowaPlusType::setDrugaProbaDoreczeniaPoLiczbieDni()
     * @uses PrzesylkaBiznesowaPlusType::setPosteRestante()
     * @uses PrzesylkaBiznesowaPlusType::setMasa()
     * @uses PrzesylkaBiznesowaPlusType::setGabaryt()
     * @uses PrzesylkaBiznesowaPlusType::setWartosc()
     * @uses PrzesylkaBiznesowaPlusType::setKwotaTranzakcji()
     * @uses PrzesylkaBiznesowaPlusType::setOstroznie()
     * @uses PrzesylkaBiznesowaPlusType::setKategoria()
     * @uses PrzesylkaBiznesowaPlusType::setIloscPotwierdzenOdbioru()
     * @uses PrzesylkaBiznesowaPlusType::setEKontaktAdresata()
     * @uses PrzesylkaBiznesowaPlusType::setESposobPowiadomieniaAdresata()
     * @uses PrzesylkaBiznesowaPlusType::setNumerPrzesylkiKlienta()
     * @uses PrzesylkaBiznesowaPlusType::setIloscDniOczekiwaniaNaWydanie()
     * @uses PrzesylkaBiznesowaPlusType::setOczekiwanyTerminDoreczenia()
     * @uses PrzesylkaBiznesowaPlusType::setTerminRodzajPlus()
     * @uses PrzesylkaBiznesowaPlusType::setNumerTransakcjiOdbioru()
     * @param PobranieType $pobranie
     * @param PlacowkaPocztowaType $urzadWydaniaPrzesylki
     * @param SubPrzesylkaBiznesowaPlusType[] $subPrzesylka
     * @param string $dataDrugiejProbyDoreczenia
     * @param int $drugaProbaDoreczeniaPoLiczbieDni
     * @param bool $posteRestante
     * @param int $masa
     * @param string $gabaryt
     * @param int $wartosc
     * @param int $kwotaTranzakcji
     * @param bool $ostroznie
     * @param string $kategoria
     * @param int $iloscPotwierdzenOdbioru
     * @param string $eKontaktAdresata
     * @param string $eSposobPowiadomieniaAdresata
     * @param string $numerPrzesylkiKlienta
     * @param int $iloscDniOczekiwaniaNaWydanie
     * @param string $oczekiwanyTerminDoreczenia
     * @param string $terminRodzajPlus
     * @param string $numerTransakcjiOdbioru
     */
    public function __construct(PobranieType $pobranie = null, PlacowkaPocztowaType $urzadWydaniaPrzesylki = null, array $subPrzesylka = array(), $dataDrugiejProbyDoreczenia = null, $drugaProbaDoreczeniaPoLiczbieDni = null, $posteRestante = null, $masa = null, $gabaryt = null, $wartosc = null, $kwotaTranzakcji = null, $ostroznie = null, $kategoria = null, $iloscPotwierdzenOdbioru = null, $eKontaktAdresata = null, $eSposobPowiadomieniaAdresata = null, $numerPrzesylkiKlienta = null, $iloscDniOczekiwaniaNaWydanie = null, $oczekiwanyTerminDoreczenia = null, $terminRodzajPlus = null, $numerTransakcjiOdbioru = null)
    {
        $this
            ->setPobranie($pobranie)
            ->setUrzadWydaniaPrzesylki($urzadWydaniaPrzesylki)
            ->setSubPrzesylka($subPrzesylka)
            ->setDataDrugiejProbyDoreczenia($dataDrugiejProbyDoreczenia)
            ->setDrugaProbaDoreczeniaPoLiczbieDni($drugaProbaDoreczeniaPoLiczbieDni)
            ->setPosteRestante($posteRestante)
            ->setMasa($masa)
            ->setGabaryt($gabaryt)
            ->setWartosc($wartosc)
            ->setKwotaTranzakcji($kwotaTranzakcji)
            ->setOstroznie($ostroznie)
            ->setKategoria($kategoria)
            ->setIloscPotwierdzenOdbioru($iloscPotwierdzenOdbioru)
            ->setEKontaktAdresata($eKontaktAdresata)
            ->setESposobPowiadomieniaAdresata($eSposobPowiadomieniaAdresata)
            ->setNumerPrzesylkiKlienta($numerPrzesylkiKlienta)
            ->setIloscDniOczekiwaniaNaWydanie($iloscDniOczekiwaniaNaWydanie)
            ->setOczekiwanyTerminDoreczenia($oczekiwanyTerminDoreczenia)
            ->setTerminRodzajPlus($terminRodzajPlus)
            ->setNumerTransakcjiOdbioru($numerTransakcjiOdbioru);
    }
    /**
     * Get pobranie value
     * @return PobranieType|null
     */
    public function getPobranie()
    {
        return $this->pobranie;
    }
    /**
     * Set pobranie value
     * @param PobranieType $pobranie
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setPobranie(PobranieType $pobranie = null)
    {
        $this->pobranie = $pobranie;
        return $this;
    }
    /**
     * Get urzadWydaniaPrzesylki value
     * @return PlacowkaPocztowaType|null
     */
    public function getUrzadWydaniaPrzesylki()
    {
        return $this->urzadWydaniaPrzesylki;
    }
    /**
     * Set urzadWydaniaPrzesylki value
     * @param PlacowkaPocztowaType $urzadWydaniaPrzesylki
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setUrzadWydaniaPrzesylki(PlacowkaPocztowaType $urzadWydaniaPrzesylki = null)
    {
        $this->urzadWydaniaPrzesylki = $urzadWydaniaPrzesylki;
        return $this;
    }
    /**
     * Get subPrzesylka value
     * @return SubPrzesylkaBiznesowaPlusType[]|null
     */
    public function getSubPrzesylka()
    {
        return $this->subPrzesylka;
    }
    /**
     * Set subPrzesylka value
     * @param SubPrzesylkaBiznesowaPlusType[] $subPrzesylka
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setSubPrzesylka(array $subPrzesylka = array())
    {
        $this->subPrzesylka = $subPrzesylka;
        return $this;
    }
    /**
     * Add item to subPrzesylka value
     * @throws \InvalidArgumentException
     * @param SubPrzesylkaBiznesowaPlusType $item
     * @return PrzesylkaBiznesowaPlusType
     */
    public function addToSubPrzesylka(SubPrzesylkaBiznesowaPlusType $item)
    {
        $this->subPrzesylka[] = $item;
        return $this;
    }
    /**
     * Get dataDrugiejProbyDoreczenia value
     * @return string|null
     */
    public function getDataDrugiejProbyDoreczenia()
    {
        return isset($this->dataDrugiejProbyDoreczenia) ? $this->dataDrugiejProbyDoreczenia : null;
    }
    /**
     * Set dataDrugiejProbyDoreczenia value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $dataDrugiejProbyDoreczenia
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setDataDrugiejProbyDoreczenia($dataDrugiejProbyDoreczenia = null)
    {
        if (is_null($dataDrugiejProbyDoreczenia) || (is_array($dataDrugiejProbyDoreczenia) && empty($dataDrugiejProbyDoreczenia))) {
            unset($this->dataDrugiejProbyDoreczenia);
        } else {
            $this->dataDrugiejProbyDoreczenia = $dataDrugiejProbyDoreczenia;
        }
        return $this;
    }
    /**
     * Get drugaProbaDoreczeniaPoLiczbieDni value
     * @return int|null
     */
    public function getDrugaProbaDoreczeniaPoLiczbieDni()
    {
        return isset($this->drugaProbaDoreczeniaPoLiczbieDni) ? $this->drugaProbaDoreczeniaPoLiczbieDni : null;
    }
    /**
     * Set drugaProbaDoreczeniaPoLiczbieDni value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param int $drugaProbaDoreczeniaPoLiczbieDni
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setDrugaProbaDoreczeniaPoLiczbieDni($drugaProbaDoreczeniaPoLiczbieDni = null)
    {
        if (is_null($drugaProbaDoreczeniaPoLiczbieDni) || (is_array($drugaProbaDoreczeniaPoLiczbieDni) && empty($drugaProbaDoreczeniaPoLiczbieDni))) {
            unset($this->drugaProbaDoreczeniaPoLiczbieDni);
        } else {
            $this->drugaProbaDoreczeniaPoLiczbieDni = $drugaProbaDoreczeniaPoLiczbieDni;
        }
        return $this;
    }
    /**
     * Get posteRestante value
     * @return bool|null
     */
    public function getPosteRestante()
    {
        return $this->posteRestante;
    }
    /**
     * Set posteRestante value
     * @param bool $posteRestante
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setPosteRestante($posteRestante = null)
    {
        $this->posteRestante = $posteRestante;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get gabaryt value
     * @return string|null
     */
    public function getGabaryt()
    {
        return $this->gabaryt;
    }
    /**
     * Set gabaryt value
     * @param string $gabaryt
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setGabaryt($gabaryt = null)
    {
        $this->gabaryt = $gabaryt;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get kwotaTranzakcji value
     * @return int|null
     */
    public function getKwotaTranzakcji()
    {
        return $this->kwotaTranzakcji;
    }
    /**
     * Set kwotaTranzakcji value
     * @param int $kwotaTranzakcji
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setKwotaTranzakcji($kwotaTranzakcji = null)
    {
        $this->kwotaTranzakcji = $kwotaTranzakcji;
        return $this;
    }
    /**
     * Get ostroznie value
     * @return bool|null
     */
    public function getOstroznie()
    {
        return $this->ostroznie;
    }
    /**
     * Set ostroznie value
     * @param bool $ostroznie
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setOstroznie($ostroznie = null)
    {
        $this->ostroznie = $ostroznie;
        return $this;
    }
    /**
     * Get kategoria value
     * @return string|null
     */
    public function getKategoria()
    {
        return $this->kategoria;
    }
    /**
     * Set kategoria value
     * @param string $kategoria
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setKategoria($kategoria = null)
    {
        $this->kategoria = $kategoria;
        return $this;
    }
    /**
     * Get iloscPotwierdzenOdbioru value
     * @return int|null
     */
    public function getIloscPotwierdzenOdbioru()
    {
        return $this->iloscPotwierdzenOdbioru;
    }
    /**
     * Set iloscPotwierdzenOdbioru value
     * @param int $iloscPotwierdzenOdbioru
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setIloscPotwierdzenOdbioru($iloscPotwierdzenOdbioru = null)
    {
        $this->iloscPotwierdzenOdbioru = $iloscPotwierdzenOdbioru;
        return $this;
    }
    /**
     * Get eKontaktAdresata value
     * @return string|null
     */
    public function getEKontaktAdresata()
    {
        return $this->eKontaktAdresata;
    }
    /**
     * Set eKontaktAdresata value
     * @param string $eKontaktAdresata
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setEKontaktAdresata($eKontaktAdresata = null)
    {
        $this->eKontaktAdresata = $eKontaktAdresata;
        return $this;
    }
    /**
     * Get eSposobPowiadomieniaAdresata value
     * @return string|null
     */
    public function getESposobPowiadomieniaAdresata()
    {
        return $this->eSposobPowiadomieniaAdresata;
    }
    /**
     * Set eSposobPowiadomieniaAdresata value
     * @param string $eSposobPowiadomieniaAdresata
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setESposobPowiadomieniaAdresata($eSposobPowiadomieniaAdresata = null)
    {
        $this->eSposobPowiadomieniaAdresata = $eSposobPowiadomieniaAdresata;
        return $this;
    }
    /**
     * Get numerPrzesylkiKlienta value
     * @return string|null
     */
    public function getNumerPrzesylkiKlienta()
    {
        return $this->numerPrzesylkiKlienta;
    }
    /**
     * Set numerPrzesylkiKlienta value
     * @param string $numerPrzesylkiKlienta
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setNumerPrzesylkiKlienta($numerPrzesylkiKlienta = null)
    {
        $this->numerPrzesylkiKlienta = $numerPrzesylkiKlienta;
        return $this;
    }
    /**
     * Get iloscDniOczekiwaniaNaWydanie value
     * @return int|null
     */
    public function getIloscDniOczekiwaniaNaWydanie()
    {
        return $this->iloscDniOczekiwaniaNaWydanie;
    }
    /**
     * Set iloscDniOczekiwaniaNaWydanie value
     * @param int $iloscDniOczekiwaniaNaWydanie
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setIloscDniOczekiwaniaNaWydanie($iloscDniOczekiwaniaNaWydanie = null)
    {
        $this->iloscDniOczekiwaniaNaWydanie = $iloscDniOczekiwaniaNaWydanie;
        return $this;
    }
    /**
     * Get oczekiwanyTerminDoreczenia value
     * @return string|null
     */
    public function getOczekiwanyTerminDoreczenia()
    {
        return $this->oczekiwanyTerminDoreczenia;
    }
    /**
     * Set oczekiwanyTerminDoreczenia value
     * @param string $oczekiwanyTerminDoreczenia
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setOczekiwanyTerminDoreczenia($oczekiwanyTerminDoreczenia = null)
    {
        $this->oczekiwanyTerminDoreczenia = $oczekiwanyTerminDoreczenia;
        return $this;
    }
    /**
     * Get terminRodzajPlus value
     * @return string|null
     */
    public function getTerminRodzajPlus()
    {
        return $this->terminRodzajPlus;
    }
    /**
     * Set terminRodzajPlus value
     * @param string $terminRodzajPlus
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setTerminRodzajPlus($terminRodzajPlus = null)
    {
        $this->terminRodzajPlus = $terminRodzajPlus;
        return $this;
    }
    /**
     * Get numerTransakcjiOdbioru value
     * @return string|null
     */
    public function getNumerTransakcjiOdbioru()
    {
        return $this->numerTransakcjiOdbioru;
    }
    /**
     * Set numerTransakcjiOdbioru value
     * @param string $numerTransakcjiOdbioru
     * @return PrzesylkaBiznesowaPlusType
     */
    public function setNumerTransakcjiOdbioru($numerTransakcjiOdbioru = null)
    {
        $this->numerTransakcjiOdbioru = $numerTransakcjiOdbioru;
        return $this;
    }
}
