<?php
/**
 * This class stands for rodzajPaletyType EnumType
 * @subpackage Enumerations
 */
class RodzajPaletyType
{
    /**
     * Constant for value 'EUR'
     * @return string 'EUR'
     */
    const ENUM_VALUE_0 = 'EUR';
    /**
     * Constant for value 'POLPALETA'
     * @return string 'POLPALETA'
     */
    const ENUM_VALUE_1 = 'POLPALETA';
    /**
     * Constant for value 'INNA'
     * @return string 'INNA'
     */
    const ENUM_VALUE_2 = 'INNA';
    /**
     * Constant for value 'PRZEMYSLOWA'
     * @return string 'PRZEMYSLOWA'
     */
    const ENUM_VALUE_3 = 'PRZEMYSLOWA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
