<?php
/**
 * This class stands for relatedToAllegroChannelType EnumType
 * @subpackage Enumerations
 */
class RelatedToAllegroChannelType
{
    /**
     * Constant for value 'MS'
     * @return string 'MS'
     */
    const ENUM_VALUE_0 = 'MS';
    /**
     * Constant for value 'WEB_API'
     * @return string 'WEB_API'
     */
    const ENUM_VALUE_1 = 'WEB_API';
    /**
     * Constant for value 'REST_API'
     * @return string 'REST_API'
     */
    const ENUM_VALUE_2 = 'REST_API';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
