<?php
/**
 * This class stands for PrintMethodEnum EnumType
 * @subpackage Enumerations
 */
class PrintMethodEnum
{
    /**
     * Constant for value 'EACH_PARCEL_SEPARATELY'
     * @return string 'EACH_PARCEL_SEPARATELY'
     */
    const ENUM_VALUE_0 = 'EACH_PARCEL_SEPARATELY';
    /**
     * Constant for value 'ALL_PARCELS_IN_ONE_FILE'
     * @return string 'ALL_PARCELS_IN_ONE_FILE'
     */
    const ENUM_VALUE_1 = 'ALL_PARCELS_IN_ONE_FILE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
