<?php
/**
 * This class stands for rozstrzygniecieType EnumType
 * @subpackage Enumerations
 */
class RozstrzygniecieType
{
    /**
     * Constant for value 'UZASADNIONA'
     * @return string 'UZASADNIONA'
     */
    const ENUM_VALUE_0 = 'UZASADNIONA';
    /**
     * Constant for value 'NIEUZASADNIONA'
     * @return string 'NIEUZASADNIONA'
     */
    const ENUM_VALUE_1 = 'NIEUZASADNIONA';
    /**
     * Constant for value 'NIEWNIESIONA'
     * @return string 'NIEWNIESIONA'
     */
    const ENUM_VALUE_2 = 'NIEWNIESIONA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
