<?php
/**
 * This class stands for PrintKindEnum EnumType
 * @subpackage Enumerations
 */
class PrintKindEnum
{
    /**
     * Constant for value 'ADDRESS_LABEL'
     * @return string 'ADDRESS_LABEL'
     */
    const ENUM_VALUE_0 = 'ADDRESS_LABEL';
    /**
     * Constant for value 'CUSTOMS_DECLARATION'
     * @return string 'CUSTOMS_DECLARATION'
     */
    const ENUM_VALUE_1 = 'CUSTOMS_DECLARATION';
    /**
     * Constant for value 'ADDRESS_LABEL_FOR_RETURN_DOCUMENTS'
     * @return string 'ADDRESS_LABEL_FOR_RETURN_DOCUMENTS'
     */
    const ENUM_VALUE_2 = 'ADDRESS_LABEL_FOR_RETURN_DOCUMENTS';
    /**
     * Constant for value 'CHECKLIST'
     * @return string 'CHECKLIST'
     */
    const ENUM_VALUE_3 = 'CHECKLIST';
    /**
     * Constant for value 'COLLECT_ON_DELIVERY_FORM'
     * @return string 'COLLECT_ON_DELIVERY_FORM'
     */
    const ENUM_VALUE_4 = 'COLLECT_ON_DELIVERY_FORM';
    /**
     * Constant for value 'WAYBILL'
     * @return string 'WAYBILL'
     */
    const ENUM_VALUE_5 = 'WAYBILL';
    /**
     * Constant for value 'REPORT'
     * @return string 'REPORT'
     */
    const ENUM_VALUE_6 = 'REPORT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @uses self::ENUM_VALUE_4
     * @uses self::ENUM_VALUE_5
     * @uses self::ENUM_VALUE_6
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
            self::ENUM_VALUE_4,
            self::ENUM_VALUE_5,
            self::ENUM_VALUE_6,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
