<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pocztexKrajowyType StructType
 * @subpackage Structs
 */
class PocztexKrajowyType extends PrzesylkaRejestrowanaType
{
    /**
     * The terminRodzaj
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $terminRodzaj;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * - use: required
     * @var int
     */
    public $masa;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * - use: required
     * @var int
     */
    public $wartosc;
    /**
     * The uiszczaOplate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $uiszczaOplate;
    /**
     * The pobranie
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var PobranieType
     */
    public $pobranie;
    /**
     * The odbiorPrzesylkiOdNadawcy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OdbiorPrzesylkiOdNadawcyType
     */
    public $odbiorPrzesylkiOdNadawcy;
    /**
     * The doreczenie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DoreczenieType
     */
    public $doreczenie;
    /**
     * The zwrotDokumentow
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ZwrotDokumentowType
     */
    public $zwrotDokumentow;
    /**
     * The potwierdzenieOdbioru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PotwierdzenieOdbioruType
     */
    public $potwierdzenieOdbioru;
    /**
     * The potwierdzenieDoreczenia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PotwierdzenieDoreczeniaType
     */
    public $potwierdzenieDoreczenia;
    /**
     * The ubezpieczenie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UbezpieczenieType
     */
    public $ubezpieczenie;
    /**
     * The posteRestante
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $posteRestante;
    /**
     * The kopertaFirmowa
     * @var bool
     */
    public $kopertaFirmowa;
    /**
     * The ostroznie
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ostroznie;
    /**
     * The ponadgabaryt
     * @var bool
     */
    public $ponadgabaryt;
    /**
     * The odleglosc
     * @var int
     */
    public $odleglosc;
    /**
     * The zawartosc
     * @var string
     */
    public $zawartosc;
    /**
     * The sprawdzenieZawartosciPrzesylkiPrzezOdbiorce
     * @var bool
     */
    public $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce;
    /**
     * The numerPrzesylkiKlienta
     * @var string
     */
    public $numerPrzesylkiKlienta;
    /**
     * Constructor method for pocztexKrajowyType
     * @uses PocztexKrajowyType::setTerminRodzaj()
     * @uses PocztexKrajowyType::setMasa()
     * @uses PocztexKrajowyType::setWartosc()
     * @uses PocztexKrajowyType::setUiszczaOplate()
     * @uses PocztexKrajowyType::setPobranie()
     * @uses PocztexKrajowyType::setOdbiorPrzesylkiOdNadawcy()
     * @uses PocztexKrajowyType::setDoreczenie()
     * @uses PocztexKrajowyType::setZwrotDokumentow()
     * @uses PocztexKrajowyType::setPotwierdzenieOdbioru()
     * @uses PocztexKrajowyType::setPotwierdzenieDoreczenia()
     * @uses PocztexKrajowyType::setUbezpieczenie()
     * @uses PocztexKrajowyType::setPosteRestante()
     * @uses PocztexKrajowyType::setKopertaFirmowa()
     * @uses PocztexKrajowyType::setOstroznie()
     * @uses PocztexKrajowyType::setPonadgabaryt()
     * @uses PocztexKrajowyType::setOdleglosc()
     * @uses PocztexKrajowyType::setZawartosc()
     * @uses PocztexKrajowyType::setSprawdzenieZawartosciPrzesylkiPrzezOdbiorce()
     * @uses PocztexKrajowyType::setNumerPrzesylkiKlienta()
     * @param string $terminRodzaj
     * @param int $masa
     * @param int $wartosc
     * @param string $uiszczaOplate
     * @param PobranieType $pobranie
     * @param OdbiorPrzesylkiOdNadawcyType $odbiorPrzesylkiOdNadawcy
     * @param DoreczenieType $doreczenie
     * @param ZwrotDokumentowType $zwrotDokumentow
     * @param PotwierdzenieOdbioruType $potwierdzenieOdbioru
     * @param PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia
     * @param UbezpieczenieType $ubezpieczenie
     * @param bool $posteRestante
     * @param bool $kopertaFirmowa
     * @param bool $ostroznie
     * @param bool $ponadgabaryt
     * @param int $odleglosc
     * @param string $zawartosc
     * @param bool $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce
     * @param string $numerPrzesylkiKlienta
     */
    public function __construct($terminRodzaj = null, $masa = null, $wartosc = null, $uiszczaOplate = null, PobranieType $pobranie = null, OdbiorPrzesylkiOdNadawcyType $odbiorPrzesylkiOdNadawcy = null, DoreczenieType $doreczenie = null, ZwrotDokumentowType $zwrotDokumentow = null, PotwierdzenieOdbioruType $potwierdzenieOdbioru = null, PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia = null, UbezpieczenieType $ubezpieczenie = null, $posteRestante = false, $kopertaFirmowa = null, $ostroznie = null, $ponadgabaryt = null, $odleglosc = null, $zawartosc = null, $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce = null, $numerPrzesylkiKlienta = null)
    {
        $this
            ->setTerminRodzaj($terminRodzaj)
            ->setMasa($masa)
            ->setWartosc($wartosc)
            ->setUiszczaOplate($uiszczaOplate)
            ->setPobranie($pobranie)
            ->setOdbiorPrzesylkiOdNadawcy($odbiorPrzesylkiOdNadawcy)
            ->setDoreczenie($doreczenie)
            ->setZwrotDokumentow($zwrotDokumentow)
            ->setPotwierdzenieOdbioru($potwierdzenieOdbioru)
            ->setPotwierdzenieDoreczenia($potwierdzenieDoreczenia)
            ->setUbezpieczenie($ubezpieczenie)
            ->setPosteRestante($posteRestante)
            ->setKopertaFirmowa($kopertaFirmowa)
            ->setOstroznie($ostroznie)
            ->setPonadgabaryt($ponadgabaryt)
            ->setOdleglosc($odleglosc)
            ->setZawartosc($zawartosc)
            ->setSprawdzenieZawartosciPrzesylkiPrzezOdbiorce($sprawdzenieZawartosciPrzesylkiPrzezOdbiorce)
            ->setNumerPrzesylkiKlienta($numerPrzesylkiKlienta);
    }
    /**
     * Get terminRodzaj value
     * @return string
     */
    public function getTerminRodzaj()
    {
        return $this->terminRodzaj;
    }
    /**
     * Set terminRodzaj value
     * @param string $terminRodzaj
     * @return PocztexKrajowyType
     */
    public function setTerminRodzaj($terminRodzaj = null)
    {
        $this->terminRodzaj = $terminRodzaj;
        return $this;
    }
    /**
     * Get masa value
     * @return int
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return PocztexKrajowyType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return PocztexKrajowyType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get uiszczaOplate value
     * @return string
     */
    public function getUiszczaOplate()
    {
        return $this->uiszczaOplate;
    }
    /**
     * Set uiszczaOplate value
     * @param string $uiszczaOplate
     * @return PocztexKrajowyType
     */
    public function setUiszczaOplate($uiszczaOplate = null)
    {
        $this->uiszczaOplate = $uiszczaOplate;
        return $this;
    }
    /**
     * Get pobranie value
     * @return PobranieType|null
     */
    public function getPobranie()
    {
        return $this->pobranie;
    }
    /**
     * Set pobranie value
     * @param PobranieType $pobranie
     * @return PocztexKrajowyType
     */
    public function setPobranie(PobranieType $pobranie = null)
    {
        $this->pobranie = $pobranie;
        return $this;
    }
    /**
     * Get odbiorPrzesylkiOdNadawcy value
     * @return OdbiorPrzesylkiOdNadawcyType|null
     */
    public function getOdbiorPrzesylkiOdNadawcy()
    {
        return $this->odbiorPrzesylkiOdNadawcy;
    }
    /**
     * Set odbiorPrzesylkiOdNadawcy value
     * @param OdbiorPrzesylkiOdNadawcyType $odbiorPrzesylkiOdNadawcy
     * @return PocztexKrajowyType
     */
    public function setOdbiorPrzesylkiOdNadawcy(OdbiorPrzesylkiOdNadawcyType $odbiorPrzesylkiOdNadawcy = null)
    {
        $this->odbiorPrzesylkiOdNadawcy = $odbiorPrzesylkiOdNadawcy;
        return $this;
    }
    /**
     * Get doreczenie value
     * @return DoreczenieType|null
     */
    public function getDoreczenie()
    {
        return $this->doreczenie;
    }
    /**
     * Set doreczenie value
     * @param DoreczenieType $doreczenie
     * @return PocztexKrajowyType
     */
    public function setDoreczenie(DoreczenieType $doreczenie = null)
    {
        $this->doreczenie = $doreczenie;
        return $this;
    }
    /**
     * Get zwrotDokumentow value
     * @return ZwrotDokumentowType|null
     */
    public function getZwrotDokumentow()
    {
        return $this->zwrotDokumentow;
    }
    /**
     * Set zwrotDokumentow value
     * @param ZwrotDokumentowType $zwrotDokumentow
     * @return PocztexKrajowyType
     */
    public function setZwrotDokumentow(ZwrotDokumentowType $zwrotDokumentow = null)
    {
        $this->zwrotDokumentow = $zwrotDokumentow;
        return $this;
    }
    /**
     * Get potwierdzenieOdbioru value
     * @return PotwierdzenieOdbioruType|null
     */
    public function getPotwierdzenieOdbioru()
    {
        return $this->potwierdzenieOdbioru;
    }
    /**
     * Set potwierdzenieOdbioru value
     * @param PotwierdzenieOdbioruType $potwierdzenieOdbioru
     * @return PocztexKrajowyType
     */
    public function setPotwierdzenieOdbioru(PotwierdzenieOdbioruType $potwierdzenieOdbioru = null)
    {
        $this->potwierdzenieOdbioru = $potwierdzenieOdbioru;
        return $this;
    }
    /**
     * Get potwierdzenieDoreczenia value
     * @return PotwierdzenieDoreczeniaType|null
     */
    public function getPotwierdzenieDoreczenia()
    {
        return $this->potwierdzenieDoreczenia;
    }
    /**
     * Set potwierdzenieDoreczenia value
     * @param PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia
     * @return PocztexKrajowyType
     */
    public function setPotwierdzenieDoreczenia(PotwierdzenieDoreczeniaType $potwierdzenieDoreczenia = null)
    {
        $this->potwierdzenieDoreczenia = $potwierdzenieDoreczenia;
        return $this;
    }
    /**
     * Get ubezpieczenie value
     * @return UbezpieczenieType|null
     */
    public function getUbezpieczenie()
    {
        return $this->ubezpieczenie;
    }
    /**
     * Set ubezpieczenie value
     * @param UbezpieczenieType $ubezpieczenie
     * @return PocztexKrajowyType
     */
    public function setUbezpieczenie(UbezpieczenieType $ubezpieczenie = null)
    {
        $this->ubezpieczenie = $ubezpieczenie;
        return $this;
    }
    /**
     * Get posteRestante value
     * @return bool|null
     */
    public function getPosteRestante()
    {
        return $this->posteRestante;
    }
    /**
     * Set posteRestante value
     * @param bool $posteRestante
     * @return PocztexKrajowyType
     */
    public function setPosteRestante($posteRestante = false)
    {
        $this->posteRestante = $posteRestante;
        return $this;
    }
    /**
     * Get kopertaFirmowa value
     * @return bool|null
     */
    public function getKopertaFirmowa()
    {
        return $this->kopertaFirmowa;
    }
    /**
     * Set kopertaFirmowa value
     * @param bool $kopertaFirmowa
     * @return PocztexKrajowyType
     */
    public function setKopertaFirmowa($kopertaFirmowa = null)
    {
        $this->kopertaFirmowa = $kopertaFirmowa;
        return $this;
    }
    /**
     * Get ostroznie value
     * @return bool|null
     */
    public function getOstroznie()
    {
        return $this->ostroznie;
    }
    /**
     * Set ostroznie value
     * @param bool $ostroznie
     * @return PocztexKrajowyType
     */
    public function setOstroznie($ostroznie = null)
    {
        $this->ostroznie = $ostroznie;
        return $this;
    }
    /**
     * Get ponadgabaryt value
     * @return bool|null
     */
    public function getPonadgabaryt()
    {
        return $this->ponadgabaryt;
    }
    /**
     * Set ponadgabaryt value
     * @param bool $ponadgabaryt
     * @return PocztexKrajowyType
     */
    public function setPonadgabaryt($ponadgabaryt = null)
    {
        $this->ponadgabaryt = $ponadgabaryt;
        return $this;
    }
    /**
     * Get odleglosc value
     * @return int|null
     */
    public function getOdleglosc()
    {
        return $this->odleglosc;
    }
    /**
     * Set odleglosc value
     * @param int $odleglosc
     * @return PocztexKrajowyType
     */
    public function setOdleglosc($odleglosc = null)
    {
        $this->odleglosc = $odleglosc;
        return $this;
    }
    /**
     * Get zawartosc value
     * @return string|null
     */
    public function getZawartosc()
    {
        return $this->zawartosc;
    }
    /**
     * Set zawartosc value
     * @param string $zawartosc
     * @return PocztexKrajowyType
     */
    public function setZawartosc($zawartosc = null)
    {
        $this->zawartosc = $zawartosc;
        return $this;
    }
    /**
     * Get sprawdzenieZawartosciPrzesylkiPrzezOdbiorce value
     * @return bool|null
     */
    public function getSprawdzenieZawartosciPrzesylkiPrzezOdbiorce()
    {
        return $this->sprawdzenieZawartosciPrzesylkiPrzezOdbiorce;
    }
    /**
     * Set sprawdzenieZawartosciPrzesylkiPrzezOdbiorce value
     * @param bool $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce
     * @return PocztexKrajowyType
     */
    public function setSprawdzenieZawartosciPrzesylkiPrzezOdbiorce($sprawdzenieZawartosciPrzesylkiPrzezOdbiorce = null)
    {
        $this->sprawdzenieZawartosciPrzesylkiPrzezOdbiorce = $sprawdzenieZawartosciPrzesylkiPrzezOdbiorce;
        return $this;
    }
    /**
     * Get numerPrzesylkiKlienta value
     * @return string|null
     */
    public function getNumerPrzesylkiKlienta()
    {
        return $this->numerPrzesylkiKlienta;
    }
    /**
     * Set numerPrzesylkiKlienta value
     * @param string $numerPrzesylkiKlienta
     * @return PocztexKrajowyType
     */
    public function setNumerPrzesylkiKlienta($numerPrzesylkiKlienta = null)
    {
        $this->numerPrzesylkiKlienta = $numerPrzesylkiKlienta;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return PocztexKrajowyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
