<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subUslugaPaczkowaType StructType
 * @subpackage Structs
 */
class SubUslugaPaczkowaType extends PrzesylkaType
{
    /**
     * The pobranie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PobranieType
     */
    public $pobranie;
    /**
     * The ubezpieczenie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UbezpieczenieType
     */
    public $ubezpieczenie;
    /**
     * The numerNadania
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 13
     * @var string
     */
    public $numerNadania;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $wartosc;
    /**
     * The ostroznie
     * @var bool
     */
    public $ostroznie;
    /**
     * The opakowanie
     * @var string
     */
    public $opakowanie;
    /**
     * The ponadgabaryt
     * @var bool
     */
    public $ponadgabaryt;
    /**
     * The numerPrzesylkiKlienta
     * @var string
     */
    public $numerPrzesylkiKlienta;
    /**
     * The gabaryt
     * @var string
     */
    public $gabaryt;
    /**
     * Constructor method for subUslugaPaczkowaType
     * @uses SubUslugaPaczkowaType::setPobranie()
     * @uses SubUslugaPaczkowaType::setUbezpieczenie()
     * @uses SubUslugaPaczkowaType::setNumerNadania()
     * @uses SubUslugaPaczkowaType::setMasa()
     * @uses SubUslugaPaczkowaType::setWartosc()
     * @uses SubUslugaPaczkowaType::setOstroznie()
     * @uses SubUslugaPaczkowaType::setOpakowanie()
     * @uses SubUslugaPaczkowaType::setPonadgabaryt()
     * @uses SubUslugaPaczkowaType::setNumerPrzesylkiKlienta()
     * @uses SubUslugaPaczkowaType::setGabaryt()
     * @param PobranieType $pobranie
     * @param UbezpieczenieType $ubezpieczenie
     * @param string $numerNadania
     * @param int $masa
     * @param int $wartosc
     * @param bool $ostroznie
     * @param string $opakowanie
     * @param bool $ponadgabaryt
     * @param string $numerPrzesylkiKlienta
     * @param string $gabaryt
     */
    public function __construct(PobranieType $pobranie = null, UbezpieczenieType $ubezpieczenie = null, $numerNadania = null, $masa = null, $wartosc = null, $ostroznie = null, $opakowanie = null, $ponadgabaryt = null, $numerPrzesylkiKlienta = null, $gabaryt = null)
    {
        $this
            ->setPobranie($pobranie)
            ->setUbezpieczenie($ubezpieczenie)
            ->setNumerNadania($numerNadania)
            ->setMasa($masa)
            ->setWartosc($wartosc)
            ->setOstroznie($ostroznie)
            ->setOpakowanie($opakowanie)
            ->setPonadgabaryt($ponadgabaryt)
            ->setNumerPrzesylkiKlienta($numerPrzesylkiKlienta)
            ->setGabaryt($gabaryt);
    }
    /**
     * Get pobranie value
     * @return PobranieType|null
     */
    public function getPobranie()
    {
        return $this->pobranie;
    }
    /**
     * Set pobranie value
     * @param PobranieType $pobranie
     * @return SubUslugaPaczkowaType
     */
    public function setPobranie(PobranieType $pobranie = null)
    {
        $this->pobranie = $pobranie;
        return $this;
    }
    /**
     * Get ubezpieczenie value
     * @return UbezpieczenieType|null
     */
    public function getUbezpieczenie()
    {
        return $this->ubezpieczenie;
    }
    /**
     * Set ubezpieczenie value
     * @param UbezpieczenieType $ubezpieczenie
     * @return SubUslugaPaczkowaType
     */
    public function setUbezpieczenie(UbezpieczenieType $ubezpieczenie = null)
    {
        $this->ubezpieczenie = $ubezpieczenie;
        return $this;
    }
    /**
     * Get numerNadania value
     * @return string|null
     */
    public function getNumerNadania()
    {
        return $this->numerNadania;
    }
    /**
     * Set numerNadania value
     * @param string $numerNadania
     * @return SubUslugaPaczkowaType
     */
    public function setNumerNadania($numerNadania = null)
    {
        $this->numerNadania = $numerNadania;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return SubUslugaPaczkowaType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return SubUslugaPaczkowaType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get ostroznie value
     * @return bool|null
     */
    public function getOstroznie()
    {
        return $this->ostroznie;
    }
    /**
     * Set ostroznie value
     * @param bool $ostroznie
     * @return SubUslugaPaczkowaType
     */
    public function setOstroznie($ostroznie = null)
    {
        $this->ostroznie = $ostroznie;
        return $this;
    }
    /**
     * Get opakowanie value
     * @return string|null
     */
    public function getOpakowanie()
    {
        return $this->opakowanie;
    }
    /**
     * Set opakowanie value
     * @param string $opakowanie
     * @return SubUslugaPaczkowaType
     */
    public function setOpakowanie($opakowanie = null)
    {
        $this->opakowanie = $opakowanie;
        return $this;
    }
    /**
     * Get ponadgabaryt value
     * @return bool|null
     */
    public function getPonadgabaryt()
    {
        return $this->ponadgabaryt;
    }
    /**
     * Set ponadgabaryt value
     * @param bool $ponadgabaryt
     * @return SubUslugaPaczkowaType
     */
    public function setPonadgabaryt($ponadgabaryt = null)
    {
        $this->ponadgabaryt = $ponadgabaryt;
        return $this;
    }
    /**
     * Get numerPrzesylkiKlienta value
     * @return string|null
     */
    public function getNumerPrzesylkiKlienta()
    {
        return $this->numerPrzesylkiKlienta;
    }
    /**
     * Set numerPrzesylkiKlienta value
     * @param string $numerPrzesylkiKlienta
     * @return SubUslugaPaczkowaType
     */
    public function setNumerPrzesylkiKlienta($numerPrzesylkiKlienta = null)
    {
        $this->numerPrzesylkiKlienta = $numerPrzesylkiKlienta;
        return $this;
    }
    /**
     * Get gabaryt value
     * @return string|null
     */
    public function getGabaryt()
    {
        return $this->gabaryt;
    }
    /**
     * Set gabaryt value
     * @param string $gabaryt
     * @return SubUslugaPaczkowaType
     */
    public function setGabaryt($gabaryt = null)
    {
        $this->gabaryt = $gabaryt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return SubUslugaPaczkowaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
