<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subPrzesylkaBiznesowaPlusType StructType
 * @subpackage Structs
 */
class SubPrzesylkaBiznesowaPlusType extends PrzesylkaType
{
    /**
     * The pobranie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PobranieType
     */
    public $pobranie;
    /**
     * The numerNadania
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 13
     * @var string
     */
    public $numerNadania;
    /**
     * The masa
     * Meta information extracted from the WSDL
     * - documentation: masa przesyłki podana w gramach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 1
     * @var int
     */
    public $masa;
    /**
     * The gabaryt
     * @var string
     */
    public $gabaryt;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $wartosc;
    /**
     * The ostroznie
     * @var bool
     */
    public $ostroznie;
    /**
     * The numerPrzesylkiKlienta
     * @var string
     */
    public $numerPrzesylkiKlienta;
    /**
     * The kwotaTranzakcji
     * @var int
     */
    public $kwotaTranzakcji;
    /**
     * The numerTransakcjiOdbioru
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $numerTransakcjiOdbioru;
    /**
     * Constructor method for subPrzesylkaBiznesowaPlusType
     * @uses SubPrzesylkaBiznesowaPlusType::setPobranie()
     * @uses SubPrzesylkaBiznesowaPlusType::setNumerNadania()
     * @uses SubPrzesylkaBiznesowaPlusType::setMasa()
     * @uses SubPrzesylkaBiznesowaPlusType::setGabaryt()
     * @uses SubPrzesylkaBiznesowaPlusType::setWartosc()
     * @uses SubPrzesylkaBiznesowaPlusType::setOstroznie()
     * @uses SubPrzesylkaBiznesowaPlusType::setNumerPrzesylkiKlienta()
     * @uses SubPrzesylkaBiznesowaPlusType::setKwotaTranzakcji()
     * @uses SubPrzesylkaBiznesowaPlusType::setNumerTransakcjiOdbioru()
     * @param PobranieType $pobranie
     * @param string $numerNadania
     * @param int $masa
     * @param string $gabaryt
     * @param int $wartosc
     * @param bool $ostroznie
     * @param string $numerPrzesylkiKlienta
     * @param int $kwotaTranzakcji
     * @param string $numerTransakcjiOdbioru
     */
    public function __construct(PobranieType $pobranie = null, $numerNadania = null, $masa = null, $gabaryt = null, $wartosc = null, $ostroznie = null, $numerPrzesylkiKlienta = null, $kwotaTranzakcji = null, $numerTransakcjiOdbioru = null)
    {
        $this
            ->setPobranie($pobranie)
            ->setNumerNadania($numerNadania)
            ->setMasa($masa)
            ->setGabaryt($gabaryt)
            ->setWartosc($wartosc)
            ->setOstroznie($ostroznie)
            ->setNumerPrzesylkiKlienta($numerPrzesylkiKlienta)
            ->setKwotaTranzakcji($kwotaTranzakcji)
            ->setNumerTransakcjiOdbioru($numerTransakcjiOdbioru);
    }
    /**
     * Get pobranie value
     * @return PobranieType|null
     */
    public function getPobranie()
    {
        return $this->pobranie;
    }
    /**
     * Set pobranie value
     * @param PobranieType $pobranie
     * @return SubPrzesylkaBiznesowaPlusType
     */
    public function setPobranie(PobranieType $pobranie = null)
    {
        $this->pobranie = $pobranie;
        return $this;
    }
    /**
     * Get numerNadania value
     * @return string|null
     */
    public function getNumerNadania()
    {
        return $this->numerNadania;
    }
    /**
     * Set numerNadania value
     * @param string $numerNadania
     * @return SubPrzesylkaBiznesowaPlusType
     */
    public function setNumerNadania($numerNadania = null)
    {
        $this->numerNadania = $numerNadania;
        return $this;
    }
    /**
     * Get masa value
     * @return int|null
     */
    public function getMasa()
    {
        return $this->masa;
    }
    /**
     * Set masa value
     * @param int $masa
     * @return SubPrzesylkaBiznesowaPlusType
     */
    public function setMasa($masa = null)
    {
        $this->masa = $masa;
        return $this;
    }
    /**
     * Get gabaryt value
     * @return string|null
     */
    public function getGabaryt()
    {
        return $this->gabaryt;
    }
    /**
     * Set gabaryt value
     * @param string $gabaryt
     * @return SubPrzesylkaBiznesowaPlusType
     */
    public function setGabaryt($gabaryt = null)
    {
        $this->gabaryt = $gabaryt;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return SubPrzesylkaBiznesowaPlusType
     */
    public function setWartosc($wartosc = null)
    {
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get ostroznie value
     * @return bool|null
     */
    public function getOstroznie()
    {
        return $this->ostroznie;
    }
    /**
     * Set ostroznie value
     * @param bool $ostroznie
     * @return SubPrzesylkaBiznesowaPlusType
     */
    public function setOstroznie($ostroznie = null)
    {
        $this->ostroznie = $ostroznie;
        return $this;
    }
    /**
     * Get numerPrzesylkiKlienta value
     * @return string|null
     */
    public function getNumerPrzesylkiKlienta()
    {
        return $this->numerPrzesylkiKlienta;
    }
    /**
     * Set numerPrzesylkiKlienta value
     * @param string $numerPrzesylkiKlienta
     * @return SubPrzesylkaBiznesowaPlusType
     */
    public function setNumerPrzesylkiKlienta($numerPrzesylkiKlienta = null)
    {
        $this->numerPrzesylkiKlienta = $numerPrzesylkiKlienta;
        return $this;
    }
    /**
     * Get kwotaTranzakcji value
     * @return int|null
     */
    public function getKwotaTranzakcji()
    {
        return $this->kwotaTranzakcji;
    }
    /**
     * Set kwotaTranzakcji value
     * @param int $kwotaTranzakcji
     * @return SubPrzesylkaBiznesowaPlusType
     */
    public function setKwotaTranzakcji($kwotaTranzakcji = null)
    {
        $this->kwotaTranzakcji = $kwotaTranzakcji;
        return $this;
    }
    /**
     * Get numerTransakcjiOdbioru value
     * @return string|null
     */
    public function getNumerTransakcjiOdbioru()
    {
        return $this->numerTransakcjiOdbioru;
    }
    /**
     * Set numerTransakcjiOdbioru value
     * @param string $numerTransakcjiOdbioru
     * @return SubPrzesylkaBiznesowaPlusType
     */
    public function setNumerTransakcjiOdbioru($numerTransakcjiOdbioru = null)
    {
        $this->numerTransakcjiOdbioru = $numerTransakcjiOdbioru;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return SubPrzesylkaBiznesowaPlusType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
