<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for przesylkaEPOType StructType
 * @subpackage Structs
 */
class PrzesylkaEPOType extends AbstractStructBase
{
    /**
     * The EPOInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EPOInfoType
     */
    public $EPOInfo;
    /**
     * The biometricSignatureContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $biometricSignatureContent;
    /**
     * The guid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 32
     * - whiteSpace: collapse
     * @var string
     */
    public $guid;
    /**
     * The numerNadania
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 13
     * @var string
     */
    public $numerNadania;
    /**
     * The statusEPO
     * @var string
     */
    public $statusEPO;
    /**
     * Constructor method for przesylkaEPOType
     * @uses PrzesylkaEPOType::setEPOInfo()
     * @uses PrzesylkaEPOType::setBiometricSignatureContent()
     * @uses PrzesylkaEPOType::setGuid()
     * @uses PrzesylkaEPOType::setNumerNadania()
     * @uses PrzesylkaEPOType::setStatusEPO()
     * @param EPOInfoType $ePOInfo
     * @param string $biometricSignatureContent
     * @param string $guid
     * @param string $numerNadania
     * @param string $statusEPO
     */
    public function __construct(EPOInfoType $ePOInfo = null, $biometricSignatureContent = null, $guid = null, $numerNadania = null, $statusEPO = null)
    {
        $this
            ->setEPOInfo($ePOInfo)
            ->setBiometricSignatureContent($biometricSignatureContent)
            ->setGuid($guid)
            ->setNumerNadania($numerNadania)
            ->setStatusEPO($statusEPO);
    }
    /**
     * Get EPOInfo value
     * @return EPOInfoType|null
     */
    public function getEPOInfo()
    {
        return $this->EPOInfo;
    }
    /**
     * Set EPOInfo value
     * @param EPOInfoType $ePOInfo
     * @return PrzesylkaEPOType
     */
    public function setEPOInfo(EPOInfoType $ePOInfo = null)
    {
        $this->EPOInfo = $ePOInfo;
        return $this;
    }
    /**
     * Get biometricSignatureContent value
     * @return string|null
     */
    public function getBiometricSignatureContent()
    {
        return $this->biometricSignatureContent;
    }
    /**
     * Set biometricSignatureContent value
     * @param string $biometricSignatureContent
     * @return PrzesylkaEPOType
     */
    public function setBiometricSignatureContent($biometricSignatureContent = null)
    {
        $this->biometricSignatureContent = $biometricSignatureContent;
        return $this;
    }
    /**
     * Get guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return PrzesylkaEPOType
     */
    public function setGuid($guid = null)
    {
        $this->guid = $guid;
        return $this;
    }
    /**
     * Get numerNadania value
     * @return string|null
     */
    public function getNumerNadania()
    {
        return $this->numerNadania;
    }
    /**
     * Set numerNadania value
     * @param string $numerNadania
     * @return PrzesylkaEPOType
     */
    public function setNumerNadania($numerNadania = null)
    {
        $this->numerNadania = $numerNadania;
        return $this;
    }
    /**
     * Get statusEPO value
     * @return string|null
     */
    public function getStatusEPO()
    {
        return $this->statusEPO;
    }
    /**
     * Set statusEPO value
     * @param string $statusEPO
     * @return PrzesylkaEPOType
     */
    public function setStatusEPO($statusEPO = null)
    {
        $this->statusEPO = $statusEPO;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return PrzesylkaEPOType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
