<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deklaracjaCelna2Type StructType
 * @subpackage Structs
 */
class DeklaracjaCelna2Type extends AbstractStructBase
{
    /**
     * The rodzaj
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $rodzaj;
    /**
     * The zawartoscPrzesylki
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $zawartoscPrzesylki;
    /**
     * The walutaKodISO
     * Meta informations extracted from the WSDL
     * - documentation: Kod ISO waluty w której wyrażone są wartości pozycji podanych w elemencie szczegolyZawartosciPrzesylki
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $walutaKodISO;
    /**
     * The szczegolyZawartosciPrzesylki
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 1
     * @var SzczegolyZawartosciPrzesylkiZagranicznejType[]
     */
    public $szczegolyZawartosciPrzesylki;
    /**
     * The dokumentyTowarzyszace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var DokumentyTowarzyszaceType[]
     */
    public $dokumentyTowarzyszace;
    /**
     * The wyjasnienie
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $wyjasnienie;
    /**
     * The oplatyPocztowe
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $oplatyPocztowe;
    /**
     * The uwagi
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $uwagi;
    /**
     * The numerReferencyjnyImportera
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numerReferencyjnyImportera;
    /**
     * The numerTelefonuImportera
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numerTelefonuImportera;
    /**
     * The numerReferencyjnyCelny
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numerReferencyjnyCelny;
    /**
     * Constructor method for deklaracjaCelna2Type
     * @uses DeklaracjaCelna2Type::setRodzaj()
     * @uses DeklaracjaCelna2Type::setZawartoscPrzesylki()
     * @uses DeklaracjaCelna2Type::setWalutaKodISO()
     * @uses DeklaracjaCelna2Type::setSzczegolyZawartosciPrzesylki()
     * @uses DeklaracjaCelna2Type::setDokumentyTowarzyszace()
     * @uses DeklaracjaCelna2Type::setWyjasnienie()
     * @uses DeklaracjaCelna2Type::setOplatyPocztowe()
     * @uses DeklaracjaCelna2Type::setUwagi()
     * @uses DeklaracjaCelna2Type::setNumerReferencyjnyImportera()
     * @uses DeklaracjaCelna2Type::setNumerTelefonuImportera()
     * @uses DeklaracjaCelna2Type::setNumerReferencyjnyCelny()
     * @param string $rodzaj
     * @param string $zawartoscPrzesylki
     * @param string $walutaKodISO
     * @param SzczegolyZawartosciPrzesylkiZagranicznejType[] $szczegolyZawartosciPrzesylki
     * @param DokumentyTowarzyszaceType[] $dokumentyTowarzyszace
     * @param string $wyjasnienie
     * @param string $oplatyPocztowe
     * @param string $uwagi
     * @param string $numerReferencyjnyImportera
     * @param string $numerTelefonuImportera
     * @param string $numerReferencyjnyCelny
     */
    public function __construct($rodzaj = null, $zawartoscPrzesylki = null, $walutaKodISO = null, array $szczegolyZawartosciPrzesylki = array(), array $dokumentyTowarzyszace = array(), $wyjasnienie = null, $oplatyPocztowe = null, $uwagi = null, $numerReferencyjnyImportera = null, $numerTelefonuImportera = null, $numerReferencyjnyCelny = null)
    {
        $this
            ->setRodzaj($rodzaj)
            ->setZawartoscPrzesylki($zawartoscPrzesylki)
            ->setWalutaKodISO($walutaKodISO)
            ->setSzczegolyZawartosciPrzesylki($szczegolyZawartosciPrzesylki)
            ->setDokumentyTowarzyszace($dokumentyTowarzyszace)
            ->setWyjasnienie($wyjasnienie)
            ->setOplatyPocztowe($oplatyPocztowe)
            ->setUwagi($uwagi)
            ->setNumerReferencyjnyImportera($numerReferencyjnyImportera)
            ->setNumerTelefonuImportera($numerTelefonuImportera)
            ->setNumerReferencyjnyCelny($numerReferencyjnyCelny);
    }
    /**
     * Get rodzaj value
     * @return string
     */
    public function getRodzaj()
    {
        return $this->rodzaj;
    }
    /**
     * Set rodzaj value
     * @param string $rodzaj
     * @return DeklaracjaCelna2Type
     */
    public function setRodzaj($rodzaj = null)
    {
        $this->rodzaj = $rodzaj;
        return $this;
    }
    /**
     * Get zawartoscPrzesylki value
     * @return string
     */
    public function getZawartoscPrzesylki()
    {
        return $this->zawartoscPrzesylki;
    }
    /**
     * Set zawartoscPrzesylki value
     * @param string $zawartoscPrzesylki
     * @return DeklaracjaCelna2Type
     */
    public function setZawartoscPrzesylki($zawartoscPrzesylki = null)
    {
        $this->zawartoscPrzesylki = $zawartoscPrzesylki;
        return $this;
    }
    /**
     * Get walutaKodISO value
     * @return string
     */
    public function getWalutaKodISO()
    {
        return $this->walutaKodISO;
    }
    /**
     * Set walutaKodISO value
     * @param string $walutaKodISO
     * @return DeklaracjaCelna2Type
     */
    public function setWalutaKodISO($walutaKodISO = null)
    {
        $this->walutaKodISO = $walutaKodISO;
        return $this;
    }
    /**
     * Get szczegolyZawartosciPrzesylki value
     * @return SzczegolyZawartosciPrzesylkiZagranicznejType[]
     */
    public function getSzczegolyZawartosciPrzesylki()
    {
        return $this->szczegolyZawartosciPrzesylki;
    }
    /**
     * Set szczegolyZawartosciPrzesylki value
     * @param SzczegolyZawartosciPrzesylkiZagranicznejType[] $szczegolyZawartosciPrzesylki
     * @return DeklaracjaCelna2Type
     */
    public function setSzczegolyZawartosciPrzesylki(array $szczegolyZawartosciPrzesylki = array())
    {
        $this->szczegolyZawartosciPrzesylki = $szczegolyZawartosciPrzesylki;
        return $this;
    }
    /**
     * Add item to szczegolyZawartosciPrzesylki value
     * @throws \InvalidArgumentException
     * @param SzczegolyZawartosciPrzesylkiZagranicznejType $item
     * @return DeklaracjaCelna2Type
     */
    public function addToSzczegolyZawartosciPrzesylki(SzczegolyZawartosciPrzesylkiZagranicznejType $item)
    {
        $this->szczegolyZawartosciPrzesylki[] = $item;
        return $this;
    }
    /**
     * Get dokumentyTowarzyszace value
     * @return DokumentyTowarzyszaceType[]|null
     */
    public function getDokumentyTowarzyszace()
    {
        return $this->dokumentyTowarzyszace;
    }
    /**
     * Set dokumentyTowarzyszace value
     * @param DokumentyTowarzyszaceType[] $dokumentyTowarzyszace
     * @return DeklaracjaCelna2Type
     */
    public function setDokumentyTowarzyszace(array $dokumentyTowarzyszace = array())
    {
        $this->dokumentyTowarzyszace = $dokumentyTowarzyszace;
        return $this;
    }
    /**
     * Add item to dokumentyTowarzyszace value
     * @throws \InvalidArgumentException
     * @param DokumentyTowarzyszaceType $item
     * @return DeklaracjaCelna2Type
     */
    public function addToDokumentyTowarzyszace(DokumentyTowarzyszaceType $item)
    {
        $this->dokumentyTowarzyszace[] = $item;
        return $this;
    }
    /**
     * Get wyjasnienie value
     * @return string|null
     */
    public function getWyjasnienie()
    {
        return $this->wyjasnienie;
    }
    /**
     * Set wyjasnienie value
     * @param string $wyjasnienie
     * @return DeklaracjaCelna2Type
     */
    public function setWyjasnienie($wyjasnienie = null)
    {
        $this->wyjasnienie = $wyjasnienie;
        return $this;
    }
    /**
     * Get oplatyPocztowe value
     * @return string|null
     */
    public function getOplatyPocztowe()
    {
        return $this->oplatyPocztowe;
    }
    /**
     * Set oplatyPocztowe value
     * @param string $oplatyPocztowe
     * @return DeklaracjaCelna2Type
     */
    public function setOplatyPocztowe($oplatyPocztowe = null)
    {
        $this->oplatyPocztowe = $oplatyPocztowe;
        return $this;
    }
    /**
     * Get uwagi value
     * @return string|null
     */
    public function getUwagi()
    {
        return $this->uwagi;
    }
    /**
     * Set uwagi value
     * @param string $uwagi
     * @return DeklaracjaCelna2Type
     */
    public function setUwagi($uwagi = null)
    {
        $this->uwagi = $uwagi;
        return $this;
    }
    /**
     * Get numerReferencyjnyImportera value
     * @return string|null
     */
    public function getNumerReferencyjnyImportera()
    {
        return $this->numerReferencyjnyImportera;
    }
    /**
     * Set numerReferencyjnyImportera value
     * @param string $numerReferencyjnyImportera
     * @return DeklaracjaCelna2Type
     */
    public function setNumerReferencyjnyImportera($numerReferencyjnyImportera = null)
    {
        $this->numerReferencyjnyImportera = $numerReferencyjnyImportera;
        return $this;
    }
    /**
     * Get numerTelefonuImportera value
     * @return string|null
     */
    public function getNumerTelefonuImportera()
    {
        return $this->numerTelefonuImportera;
    }
    /**
     * Set numerTelefonuImportera value
     * @param string $numerTelefonuImportera
     * @return DeklaracjaCelna2Type
     */
    public function setNumerTelefonuImportera($numerTelefonuImportera = null)
    {
        $this->numerTelefonuImportera = $numerTelefonuImportera;
        return $this;
    }
    /**
     * Get numerReferencyjnyCelny value
     * @return string|null
     */
    public function getNumerReferencyjnyCelny()
    {
        return $this->numerReferencyjnyCelny;
    }
    /**
     * Set numerReferencyjnyCelny value
     * @param string $numerReferencyjnyCelny
     * @return DeklaracjaCelna2Type
     */
    public function setNumerReferencyjnyCelny($numerReferencyjnyCelny = null)
    {
        $this->numerReferencyjnyCelny = $numerReferencyjnyCelny;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return DeklaracjaCelna2Type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
